/*--------------------------------------------------------------*/
/*        CORE, for GLE V3.0                                         */
/*--------------------------------------------------------------*/

/* g_scr_* needs to be added */
/* g_int_* needs to be decided/added */
/* g_tex_* needs to be decided/added */

/*---------------------------------------------------------------------------*/
#include <math.h>
#include "all.h"
#include "mygraph.h"
#include "mydev.h"
#include "core.h"
#include "justify.h"
int mystrncmp(char *a, char *b, int n);
struct gmodel g;
double tmpimg[3][3];
double tmpimg2[3][3];
double font_lwidth;
/*---------------------------------------------------------------------------*/
#if (defined M_PI && !defined PI)
#define PI M_PI
#define pi M_PI
#elif defined PI
#define pi PI
#else
#define PI 3.141592653
#define pi 3.141592653
#endif

#define true (!false)
#define false 0
#define dbg if ((gle_debug & 32)>0)
extern int gle_debug;
/*---------------------------------------------------------------------------*/
/* The global variables that CORE keeps track of */
/*-----------------------------------------------*/

static int jj;
int test_unit(void);
int gunit=false;
#define color_black 0X01000000
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
g_dfont(char *s)
{
        d_dfont(s);
}
/*---------------------------------------------------------------------------*/
int32 g_get_grey(double v)
{
        colortyp c;
        c.b[B_F] = 1;
        c.b[B_R] = 255*v;
        c.b[B_G] = 255*v;
        c.b[B_B] = 255*v;
        return c.l;
}
/*---------------------------------------------------------------------------*/
g_hint(char *s)
{
        gprint("%s\n",s);
}
/*---------------------------------------------------------------------------*/
extern int noscreenio;
g_message(char *s)
{
#ifdef EMXOS2
        extern FILE *ErrFileSURFOS2;
        extern int flagSURFOS2;

        if (flagSURFOS2)
               {
                fputs(s,ErrFileSURFOS2);
                fputs("\n",ErrFileSURFOS2);
                return;
               }
#endif
        if (noscreenio) printf("%s\n",s);
        else d_message(s);
}
/*---------------------------------------------------------------------------*/
g_source(char *s)
{
        d_source(s);
}
/*---------------------------------------------------------------------------*/
g_get_end(dbl *x,dbl *y)
{
        *x = tex_xend();
        *y = tex_yend();
}
g_set_end(dbl x,dbl y)
{
        gprint("What is setting end \n");
}
/*---------------------------------------------------------------------------*/
g_get_usersize(dbl *x,dbl *y)
{                /* Does this want device size, or user size ????? */
        *x = g.userwidth;
        *y = g.userheight;
}
g_get_devsize(dbl *x,dbl *y)
{                /* Does this want device size, or user size ????? */
        *x = g.devwidth;
        *y = g.devheight;
}
/*---------------------------------------------------------------------------*/
g_get_bounds(dbl *x1,dbl *y1,dbl *x2,dbl *y2)
{
        *x1 = g.xmin;
        *y1 = g.ymin;
        *x2 = g.xmax;
        *y2 = g.ymax;
}
/*---------------------------------------------------------------------------*/
g_init_bounds()
{
        g.xmin = 1e30;
        g.ymin = 1e30;
        g.xmax = -1e30;
        g.ymax = -1e30;
}
/*---------------------------------------------------------------------------*/
g_get_type(char *t)
{
        d_get_type(t);
}
/*---------------------------------------------------------------------------*/
g_set_path(int onoff)
{
        if (onoff==g.inpath) return;
        g_flush();
        if (onoff==true) {
                g.inpath=true;
                g.npath = 0;
                g.xinline=false;
        } else {
                g.inpath = false;
                g.xinline = false;
        }
        d_set_path(onoff);
}
/*---------------------------------------------------------------------------*/
g_get_path(int *onoff)
{
        *onoff = g.inpath;
}
/*---------------------------------------------------------------------------*/
g_newpath()
{
        g.npath = 0;
        d_newpath();
}
/*---------------------------------------------------------------------------*/
static int isopen=0;
g_open(dbl width,dbl height)
{
        if (isopen) return;
        isopen = true;
        if (width*height==0) {
          gprint("G_OPEN, Width or height was zero w=%g, h=%g\n",width,height);
          width = 10; height = 10;		/* format was "%d" a.r. */
        }
        g.userwidth = width;
        g.userheight = height;
        freeafont();
        d_open(width,height);
        g_clear();
}
/*---------------------------------------------------------------------------*/
g_close()
{
        isopen = false;
        g_flush();
        d_close();
}
/*---------------------------------------------------------------------------*/
g_set_line_cap(int i)
{
        /*  lcap, 0= butt, 1=round, 2=projecting square */
        if (i<0 || i>2) {
                gprint("Invalid line cap, {%d}, valid numbers are \n",i);
                gprint("        0= butt, 1=round, 2=projecting square \n");
        }
        d_set_line_cap(i);
        g.lcap = i;
}
/*---------------------------------------------------------------------------*/
g_set_line_join(int i)
{
        if (i<0 || i>2) {
                gprint("Invalid line join, {%d}, valid numbers are \n",i);
                gprint("        0= mitre, 1=round, 2=bevel \n");
        }
        d_set_line_join(i);
        g.ljoin = i;
}
g_get_line_join(int *i)
{
        *i = g.ljoin;
}
g_get_line_cap(int *i)
{
        *i = g.lcap;
}
/*---------------------------------------------------------------------------*/
g_set_line_miterlimit(double d)
{
        d_set_line_miterlimit(d);
        g.miterlimit = d;
}
/*---------------------------------------------------------------------------*/
g_get_line_width(double *w)
{
        *w = g.lwidth;
}
/*---------------------------------------------------------------------------*/
g_set_line_width(double w)
{
        if (w<0) return;
        d_set_line_width(w);
        g.lwidth = w;
}
g_set_font_width(double w)
{
        font_lwidth = w;
}
/*---------------------------------------------------------------------------*/
g_get_line_styled(double *w)
{
        *w = g.lstyled;
}
/*---------------------------------------------------------------------------*/
g_set_line_styled(double w)
{
        if (w==0) return;
        d_set_line_styled(w);
        g.lstyled = w;
}
/*---------------------------------------------------------------------------*/
g_set_line_style(char *s)
{
        d_set_line_style(s);
        strncpy(g.lstyle,s,8);
}
/*---------------------------------------------------------------------------*/
g_get_line_style(char *s)
{
        strncpy(s,(char *) &g.lstyle,8);
}
/*---------------------------------------------------------------------------*/
g_dev(double x, double y,double *xd,double *yd)
{
        static double xx,yy;
        if (gunit==true) { *xd = x; *yd = y; }
        else {
        xx = g.image[0][0]*x + g.image[0][1]*y + g.image[0][2];
        yy = g.image[1][0]*x + g.image[1][1]*y + g.image[1][2];
        *xd = xx;
        *yd = yy;
        }
}
/*---------------------------------------------------------------------------*/
g_undev(double ux,double uy, double *x,double *y)
{
        static double xx,yy,cdiv,xd,yd;
        if (gunit==true) { *x = ux; *y = uy; }
        else {
        cdiv = ( g.image[0][1]*g.image[1][0] - g.image[0][0]*g.image[1][1] );
        if (cdiv==0) {gprint("Image matrix FLAT, a 1D world, giving up \n");return;}
        xd = ux - g.image[0][2];
        yd = uy - g.image[1][2];
        xx = -xd*g.image[1][1] + yd*g.image[0][1];
        *x = xx/cdiv;
        yy = xd*g.image[1][0]-yd*g.image[0][0];
        *y = yy/cdiv;
        }
}
/*---------------------------------------------------------------------------*/
g_rundev(double x, double y,double *xd,double *yd)
{
        static double zx,zy;
        g_undev(0,0,&zx,&zy);
        g_undev(x,y,xd,yd);
        *xd -= zx;
        *yd -= zy;
}
g_rdev(double x, double y,double *xd,double *yd)
{
        static double zx,zy;
        g_dev(0,0,&zx,&zy);
        g_dev(x,y,xd,yd);
        *xd -= zx;
        *yd -= zy;
}
/*---------------------------------------------------------------------------*/
g_fill()
{
        d_fill();
}
/*---------------------------------------------------------------------------*/
g_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
        d_fill_ary(nwk,wkx,wky);
}
g_line_ary(int nwk,double (*wkx)[],double  (*wky)[])
{
        d_line_ary(nwk,wkx,wky);
}
/*---------------------------------------------------------------------------*/
g_stroke()
{
        d_stroke();
}
/*---------------------------------------------------------------------------*/
g_clip()
{
        /* Find the intersection of the current path with the clipping path */
        /* and thus define a new clipping path */
        d_clip();
}
/*---------------------------------------------------------------------------*/
g_set_matrix(double newmat[3][3])
{
        static double x1,y1,x2,y2,x3,y3,x4,y4;
        static double a1,b1,a2,b2,a3,b3,a4,b4;

        g_dev(g.xmin,g.ymin,&x1,&y1);
        g_dev(g.xmax,g.ymin,&x2,&y2);
        g_dev(g.xmax,g.ymax,&x3,&y3);
        g_dev(g.xmin,g.ymax,&x4,&y4);

        if (memcmp(newmat,g.image,3*3*8)!=0) d_set_matrix(newmat);
        memcpy(&g.image,newmat,3*3*8);

        g_init_bounds();

        if (g.xmin<g.xmax)  {
                g_undev(x1,y1,&a1,&b1);
                g_undev(x2,y2,&a2,&b2);
                g_undev(x3,y3,&a3,&b3);
                g_undev(x4,y4,&a4,&b4);
                g_set_bounds(a1,b1);
                g_set_bounds(a2,b2);
                g_set_bounds(a3,b3);
                g_set_bounds(a4,b4);
        }
}
/*---------------------------------------------------------------------------*/
mat_mult(double a[3][3],double b[3][3])
{
        static double c[3][3],tot;
        int y,xb,x;
        for (y=0;y<3;y++) {
          for (xb=0;xb<3;xb++) {
                tot = 0;
                for (x=0;x<3;x++) tot += a[x][y] * b[xb][x];
                c[xb][y] = tot;
          }
        }
        memcpy(a,&c,3*3*8);        /* maybe sizeof(*a) would be better? */
}
/*---------------------------------------------------------------------------*/
g_rotate(double ar)
{
        static double r[3][3],unx,uny,cx,cy;
        ar = pi*ar/180;
        r[0][0] = cos(ar);
        r[0][1] = -sin(ar);
        r[1][0] = sin(ar);
        r[1][1] = cos(ar);
        r[2][2] = 1;
        g_dev(g.curx,g.cury,&cx,&cy);
        g_rundev(-cx,-cy,&unx,&uny);
        g_translate(unx,uny);
        memcpy(tmpimg,g.image,3*3*8);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        g_rundev(cx,cy,&unx,&uny);
        g_translate(unx,uny);        /* not shore about this ORIGIN stuff */
        test_unit();
}
/*---------------------------------------------------------------------------*/
int gg_unrotate(void);
int gg_rerotate(void);
g_scale(double sx,double sy)
{
        /* The idea is to rotate or scale about the CURRENT POINT */
        static double r[3][3],unx,uny,cx,cy;
        r[0][0] = sx;
        r[1][1] = sy;
        r[2][2] = 1;

        gg_unrotate();
        g_dev(g.curx,g.cury,&cx,&cy);
        g_rundev(-cx,-cy,&unx,&uny);
        g_translate(unx,uny);
        memcpy(tmpimg,g.image,3*3*8);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        g_rundev(cx,cy,&unx,&uny);
        g_translate(unx,uny);        /* not shore about this ORIGIN stuff */
        gg_rerotate();
        test_unit();
}
void g_shear(double sx,double sy)
{
        /* The idea is to rotate or scale about the CURRENT POINT */
        static double r[3][3],unx,uny,cx,cy;
        r[0][0] = 1;
        r[1][0] = sy;
        r[1][1] = 1;
        r[0][1] = sx;
        r[2][2] = 1;

        gg_unrotate();
        g_dev(g.curx,g.cury,&cx,&cy);
        g_rundev(-cx,-cy,&unx,&uny);
        g_translate(unx,uny);
        memcpy(tmpimg,g.image,3*3*8);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        g_rundev(cx,cy,&unx,&uny);
        g_translate(unx,uny);        /* not shore about this ORIGIN stuff */
        gg_rerotate();
        test_unit();
}
static double ggra;
gg_rerotate()
{
        g_rotate(ggra);
}
gg_unrotate()
{
        double ox,oy,x1,y0,dx,dy,tt;
        g_dev(0.0,0.0,&ox,&oy);
        g_dev(1.0,0.0,&x1,&y0);
        dx = x1-ox;
        dy = y0-oy;
        tt = myatan2(dy,dx);
        ggra = tt * 180.0 / PI;
        g_rotate(-ggra);
}

/*---------------------------------------------------------------------------*/
dis_mat(char *s,double m[3][3])
{
        int i,j;
        gprint("\n Matrix {%s} \n",s);
        for (i=0;i<3;i++)
                gprint("        %f %f %f \n",m[0][i],m[1][i],m[2][i]);

}
/*---------------------------------------------------------------------------*/
g_translate(double ztx,double zty)
{
        static double tx,ty,r[3][3];
        g_rdev(ztx,zty,&tx,&ty);

        r[0][0] = 1;
        r[1][1] = 1;
        r[2][2] = 1;
        r[0][2] = tx;
        r[1][2] = ty;
        memcpy(tmpimg,g.image,3*3*8);
        mat_mult(tmpimg,r);
        g_set_matrix(tmpimg);
        test_unit();
}
/*---------------------------------------------------------------------------*/
g_move(double zx,double zy)
{
        double x,y;
        if (g.xinline==true) g_flush();
        d_move(zx,zy);
        g.curx = zx;
        g.cury = zy;
        g.closex = zx;
        g.closey = zy;
}
g_rmove(double zx,double zy)
{
        g_move(g.curx+zx,g.cury+zy);
}
g_rline(double zx,double zy)
{
        g_line(g.curx+zx,g.cury+zy);
}
/*---------------------------------------------------------------------------*/
g_reverse()         /* reverse the order of stuff in the current path */
{        d_reverse();        }
/*---------------------------------------------------------------------------*/
g_closepath()
{
        if (g.inpath) d_closepath();
        else g_line(g.closex,g.closey);
        g.curx = g.closex;
        g.cury = g.closey;
        if (!g.inpath) g_flush();
}
/*---------------------------------------------------------------------------*/
g_line(double zx,double zy)
{
        double x,y;
        d_line(zx,zy);
        if (g.xinline==false) {
                g.xinline = true;
                g_set_bounds(g.curx,g.cury);
        }
        g.curx = zx;
        g.cury = zy;
        g_set_bounds(zx,zy);
}
/*---------------------------------------------------------------------------*/
g_set_bounds(double x,double y)
{
        if (x<g.xmin) g.xmin = x;
        if (x>g.xmax) g.xmax = x;
        if (y<g.ymin) g.ymin = y;
        if (y>g.ymax) g.ymax = y;
}
/*---------------------------------------------------------------------------*/
test_unit()
{
        int i,j;
        gunit = true;
        for (i=0;i<3;i++) for (j=0;j<3;j++) if (i!=j) if(g.image[i][j]!=0.0) gunit = false;
        for (i=0;i<3;i++) if (g.image[i][i]!=1.0) gunit = false;
}
/*
        for (i=0;i<3;i++) {
                gprint("Matrix %g %g %g \n",g.image[i][0]
                        ,g.image[i][1],g.image[i][2]);
        }
*/
int tex_clear(void);
g_clear()
{
        int i,j;
        for (i=0;i<3;i++) for (j=0;j<3;j++) g.image[i][j] = 0;
        for (i=0;i<3;i++) g.image[i][i] = 1;
        d_clear();
        tex_clear();
        g_set_just(JUST_LEFT);
        g_set_line_styled(.04);
        g_set_line_style("1");
        g_set_line_width(0);
        g_set_color(color_black);
        g_set_fill(color_black);
        g_set_font(1);         /*        Load and set default font         */
        g_set_font_width(-1);         /*        Load and set default font         */
        g_set_hei(1.0);        /*        And set to 1 cm size                  */
        g_move(0.0,0.0);
        test_unit();

}
/*---------------------------------------------------------------------------*/
g_get_xy(double *x,double *y)
{
        *x = g.curx;
        *y = g.cury;
}
g_set_xy(double x, double y)        /* a synonym for MOVE */
{        g_move(x,y); }
/*---------------------------------------------------------------------------*/
g_flush()
{
        d_flush();
        g.xinline = false;
}
/*---------------------------------------------------------------------------*/
g_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
        d_arcto(x1,y1,x2,y2,rrr);

        g.curx = x2;
        g.cury = y2;
        g.xinline = true;
        /* should do MASSES of calc to find bounds of arc  */
        g_set_bounds(x1,y1);
        g_set_bounds(x2,y2);
}
/*---------------------------------------------------------------------------*/
g_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
        d_arc(r,t1,t2,cx,cy);
        g.xinline = true;
        if ((cx!=g.curx) || (cy!=g.cury)) {
                g.curx = cx + r*cos(pi*t2/180);
                g.cury = cy + r*sin(pi*t2/180);
        }
}
/*---------------------------------------------------------------------------*/
g_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
        d_narc(r,t1,t2,cx,cy);
        g.xinline = true;
        if ((cx!=g.curx) || (cy!=g.cury)) {
                g.curx = cx + r*cos(pi*t2/180);
                g.cury = cy + r*sin(pi*t2/180);
        }
}
/*---------------------------------------------------------------------------*/
g_dojust(dbl *x1, dbl *y1, dbl *x2, dbl *y2, int jj)
{
        static int jx,jy;
        static double w,y,d;
        jx = (jj & 0xf0) / 16;
        jy = jj & 0x0f;
        d = jx * (*x2-*x1)/2;
        *x1 -= d;
        *x2 -= d;
        d = jy * (*y2-*y1)/2;
        *y1 -= d;
        *y2 -= d;
}
g_dotjust(dbl *x1, dbl *y1, dbl l, dbl r, dbl u, dbl d, int jj)
{
        static int jx,jy,t;
        static double ddd;
        jx = (jj & 0xf0) / 16;
        jy = jj & 0x0f;
        t = (jj & 0xf00) / 256 ;
        ddd = jx * (-l+r)/2;
        *x1 = *x1 + -l - ddd;
        ddd = jy * (u-d)/2;
        if (t==0) *y1 = *y1 - d - ddd;
}
g_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
        double x,y;
        g_get_xy(&x,&y);
        d_box_stroke(x1,y1,x2,y2);
        g_set_bounds(x1,y1);
        g_set_bounds(x2,y2);

        g_move(x,y);
}
/*---------------------------------------------------------------------------*/
g_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
        double x,y;
        g_get_xy(&x,&y);
        d_box_fill(x1,y1,x2,y2);
        g_set_bounds(x1,y1);
        g_set_bounds(x2,y2);
        g_move(x,y);
}
/*---------------------------------------------------------------------------*/
g_circle_stroke(dbl zr)
{
        d_circle_stroke(zr);
        g_set_bounds(g.curx-zr,g.cury-zr);
        g_set_bounds(g.curx+zr,g.cury+zr);
}
g_circle_fill(dbl zr)
{
        d_circle_fill(zr);
        g_set_bounds(g.curx-zr,g.cury-zr);
        g_set_bounds(g.curx+zr,g.cury+zr);
}
/*---------------------------------------------------------------------------*/
g_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
        double x,y;
        d_bezier(x1,y1,x2,y2,x3,y3);
        if (g.xinline==false) {
                g.xinline = true;
                g_set_bounds(g.curx,g.cury);
        }
        g.curx = x3;
        g.cury = y3;
        g_set_bounds(x3,y3);
}
/*---------------------------------------------------------------------------*/
g_dmove(double x, double y)
{
        double ux,uy;
        g_undev(x,y,&ux,&uy);
        d_move(ux,uy);
        g.curx = ux;
        g.cury = uy;
}
/*---------------------------------------------------------------------------*/
g_dline(double x, double y)
{
        double ux,uy;
        g_undev(x,y,&ux,&uy);
        d_line(ux,uy);
        g.curx = ux;
        g.cury = uy;
}
/*---------------------------------------------------------------------------*/
g_dbezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
        double a1,b1,a2,b2,a3,b3;
        g_undev(x1,y1,&a1,&b1);
        g_undev(x2,y2,&a2,&b2);
        g_undev(x3,y3,&a3,&b3);
        g_bezier(a1,b1,a2,b2,a3,b3);
        g.curx = a3;
        g.cury = b3;
}
/*---------------------------------------------------------------------------*/
g_bitmap(char *bmap)
{
}
/*---------------------------------------------------------------------------*/
g_set_rgbf(double rr, double gg, double bb, double ff)
{
        /* Fill pattern is left as-is */
        g.color.b[B_R] = rr*255;
        g.color.b[B_G] = gg*255;
        g.color.b[B_B] = bb*255;
        g.color.b[B_F] = ff*255;
        d_set_color(g.color.l);
}
g_set_rgbf_fill(double rr, double gg, double bb, double ff)
{
        /* Fill pattern is left as-is */
        g.fill.b[B_R] = rr*255;
        g.fill.b[B_G] = gg*255;
        g.fill.b[B_B] = bb*255;
        g.fill.b[B_F] = ff*255;
        d_set_fill(g.fill.l);
}
g_get_rgbf(double *rr, double *gg, double *bb, double *ff)
{
        *rr = g.color.b[B_R]/255;
        *gg = g.color.b[B_G]/255;
        *bb = g.color.b[B_B]/255;
        *ff = g.color.b[B_F]/255;
}
/*---------------------------------------------------------------------------*/
g_set_color(int32 l)
{
        if (l==0) return;
        g.color.l = l;
        d_set_color(g.color.l);
}
g_get_color(int32 *l)
{
        *l = g.color.l;
}
/*---------------------------------------------------------------------------*/
g_set_fill(int32 l)
{
        g.fill.l = l;
        d_set_fill(g.fill.l);
}
g_get_fill(int32 *l)
{
        *l = g.fill.l;
}
/*---------------------------------------------------------------------------*/
g_beginclip() {
        d_beginclip(); }
g_endclip() {
        d_endclip(); }
/*---------------------------------------------------------------------------*/
static int ngsave;
static char *gsave[100];

g_gsave()
{
        ngsave++;
        if (ngsave>=99) {
                gprint("Over 99 GSAVE's, probably a loop in your code\n");
                return;
        }
        gsave[ngsave] = myallocz(SIZEOFSTATE+10);
        g_get_state(gsave[ngsave]);
}
g_grestore()
{
        static double a,b;
        g_flush();
        if (ngsave==0) {
                gprint("Attempt to GRESTORE at top of stack\n");
                if (gle_debug>0) a = a/b;
                return;
        }
        g_set_state(gsave[ngsave]);
        myfree(gsave[ngsave]);
        ngsave--;
}
g_get_state(char *s)
{
        memcpy(s,&g,SIZEOFSTATE);
}
g_set_state(char *s)
{
        memcpy(tmpimg,g.image,3*3*8);
        memcpy(&g,s,SIZEOFSTATE);
        memcpy(tmpimg2,g.image,3*3*8);
        memcpy(g.image,tmpimg,3*3*8);
        g_set_matrix(tmpimg2);
        d_set_color(g.color.l);
        d_set_fill(g.fill.l);
        d_set_line_width(g.lwidth);
        d_set_line_style(g.lstyle);
        d_set_line_styled(g.lstyled);
        test_unit();
}
        /*                 12,4,-.5,-.5,0.35,        original dot */
struct mark_struct { int ff; int cc; double rx; double ry; double scl;};
struct mark_struct minf[61];
extern char *mrk_name[];
extern char *mrk_fname[];

/* struct mark_struct { int ff, int cc, double rx, double ry, double scl;}; */
extern char *mark_name[];
extern char *mark_sub[];
extern int mark_subp[];
extern int nmark;

extern int nmrk;
g_marker(int i, double sz)
{
        g_marker2(i,sz,1.0);
}
g_marker2(int i, double sz, double dval)
{
        static double cx,cy,h,scale;
        static double x1,y1,x2,y2;
        int otype;
        if (i<0) {{
                char *stk_str[6];
                double stk[6];
                int nstk=2;
                ++i;
                i = -i;
                if (mark_subp[i]==-1) {{
                        int idx,zret,np,plist;
                        mark_subp[i] = sub_find(mark_sub[i],&idx,&zret,&np,(int **) &plist);
                        if (mark_subp[i] == 0)  {
                                gprint("You MUST define the sub before defining the marker\n");
                                return;
                        }
                }}
                stk[1] = sz;
                stk[2] = dval;
                g_get_xy(&cx,&cy);
                sub_call(mark_subp[i],(double *) &stk,(char **) &stk_str,&nstk,&otype);
                g_move(cx,cy);
                return;
        }}
        if (i<1 || i>nmrk) {gprint("Invalid marker number %d \n",i); return;}
        g_get_xy(&cx,&cy);
        g_get_hei(&h);
        i--;
        scale = minf[i].scl*sz;
        g_set_hei(scale);
        if (minf[i].ff == 0) minf[i].ff = pass_font(mrk_fname[i]);
        if (minf[i].ff == -1) {
                minf[i].ff = pass_font(mrk_fname[i]);
                char_bbox(minf[i].ff,minf[i].cc,&x1,&y1,&x2,&y2);
                minf[i].ry = (minf[i].ry + -y1-(y2-y1)/2.0);
                minf[i].rx = (minf[i].rx + -x1-(x2-x1)/2.0);
        }

        g_move(cx+minf[i].rx*scale, cy+minf[i].ry*scale);
        g_char(minf[i].ff,minf[i].cc);
        g_move(cx,cy);
        g_set_hei(h);
}
g_defmarker(char *mname,char *font, int ccc, double dx, double dy, double sz, int autodx)
{
        int i;
        if (nmrk>61-1) {gprint("Too many markers defined \n"); return;}
        i = nmrk;
        nmrk++;
        mrk_name[i] = sdup(mname);
        mrk_fname[i] = sdup(font);
        minf[i].ff = 0;
        if (autodx) minf[i].ff = -1;
        minf[i].cc = ccc;
        minf[i].rx = dx;
        minf[i].ry = dy;
        minf[i].scl = sz;
}
g_marker_def(char *mname,char *subname)
{
        int i;
        for (i=0; i<nmark; i++) if (strcmp(mname,mark_name[i])==0) {
                myfree(mark_name[i]);
                myfree(mark_sub[i]);
                nmark--;
                break;
        }
        nmark++;
        mark_name[i] = sdup(mname);
        mark_sub[i] = sdup(subname);
        mark_subp[i] = -1;
}
g_char(int font, int cc)
{
        d_char(font,cc);
}
g_text(char *ss)
{
        text_block(UC ss,0.0,g.just);
}
g_set_just(int jj)
{
        g.just = jj;
}
g_set_font(int jj)
{
        if (jj==0) return;
        font_load_metric(jj);
        g.fontn = jj;
}
g_set_hei(double h)
{
        if (h==0) {
                gprint("========================************ HEIGHT SET TO ZERO\n");
                return;
        }
        g.fontsz = h;
}
g_get_just(int *jj)
{
        *jj = g.just;
}
g_get_font(int *jj)
{
        *jj = g.fontn;
}
g_get_hei(double *h)
{
        *h = g.fontsz;
}
g_postscript(char *fname,double wx, double wy)
{
char inbuff[200];
FILE *fptr;
int i;
char *s;
double bx1=0,by1=0,bx2,by2,x,y,cx,cy;
        g_get_type(inbuff);
        if (strstr(inbuff,"PS")== NULL) {
                g_get_xy(&cx,&cy);
                g_box_stroke(cx,cy,cx+wx,cy+wy);
                return;
        }
        fptr = fopen(fname,"r");
        if (fptr==NULL) {
                gprint("Unable to open input file {%s} \n",fname);
                perror("Reason");
                return;
        }
        for (;!feof(fptr);) {
          if (fgets(inbuff,190,fptr)!=NULL) {
                if (strncmp(inbuff,"%%BoundingBox:",14)==0) {
                        s = strtok(inbuff," :\t");
                        bx1 = atof(strtok(0," :\t"));
                        by1 = atof(strtok(0," :\t"));
                        bx2 = atof(strtok(0," :\t"));
                        by2 = atof(strtok(0," :\t"));
                }
          }
        }

        g_devcmd("/GLESTATE save def \n");
        g_devcmd("gsave\n");
        g_devcmd("/a4small {} def /legal {} def\n");
        g_devcmd("/letter {} def /note {} def /copypage {} def \n");
        g_devcmd("/erasepage {} def /showpage {} def \n");
        rewind(fptr);
        g_gsave();
        g_get_xy(&cx,&cy);
        g_translate(cx,cy);
        bx2 -= bx1;
        by2 -= by1;
        if (bx2==0 || by2==0) {gprint("Invalid EPS file\n"); return;}
        g_move(0.0,0.0);
        g_scale(wx/bx2,wx/bx2); /* use wy/by2 to change aspect ratio */
        g_translate(-bx1,-by1);
        g_devcmd("0 setgray 0 setlinecap 0 setlinewidth 0 setlinejoin\n");
        g_devcmd("10 setmiterlimit [] 0 setdash\n");
        for (;!feof(fptr);) {
          if (fgets(inbuff,200,fptr)!=NULL) {
                g_devcmd(inbuff);
          }
        }
        fclose(fptr);
        g_devcmd("grestore GLESTATE restore \n");
        g_grestore();
}
g_devcmd(char *s)
{
        d_devcmd(s);
}
