/* source.c, created from source.def. */
#line 23 "(null)source.def"

#line 37 "(null)source.def"
/* source.c - Implements the `.' and `source' builtins. */

#include <sys/types.h>
#include <sys/file.h>
#include <errno.h>
#include "../shell.h"
#include "../posixstat.h"
#include "../filecntl.h"

extern int errno;

/* Read and execute commands from the file passed as argument.  Guess what.
   This cannot be done in a subshell, since things like variable assignments
   take place in there.  So, I open the file, place it into a large string,
   close the file, and then execute the string. */
source_builtin (list)
     WORD_LIST *list;
{
  extern int return_catch_flag, return_catch_value;
  extern jmp_buf return_catch;
  int result, return_val;

  /* Assume the best. */
  result = EXECUTION_SUCCESS;

  if (list)
    {
      extern char *find_path_file ();
      char *string, *filename, *tempfile;
      struct stat finfo;
      int fd, tt;

      tempfile = find_path_file (list->word->word);

      if (!tempfile)
	tempfile = savestring (list->word->word);

      filename = (char *)alloca (1 + strlen (tempfile));
      strcpy (filename, tempfile);
      free (tempfile);

      if (stat (filename, &finfo) == -1 ||
	  (fd = open (filename, O_RDONLY)) == -1)
	goto file_error_exit;

      string = (char *)xmalloc (1 + finfo.st_size);
      tt = read (fd, string, finfo.st_size);
      string[finfo.st_size] = '\0';

      /* Close the open file, preserving the state of errno. */
      { int temp = errno; close (fd); errno = temp; }

/* In OS/2 the size of the file includes CR's, so just punt the next test */
#if !defined(__EMX__)
      if (tt != finfo.st_size)
#else
	if(!tt)
#endif
	{
	  free (string);

	file_error_exit:
	  file_error (filename);
#if defined (ALLOW_RIGID_POSIX_COMPLIANCE)
	  /* POSIX shells exit if non-interactive and file error. */
	  if (getenv ("POSIX_PENDANTIC"))
	    {
	      extern int interactive_shell;

	      if (!interactive_shell)
		longjmp (top_level, EXITPROG);
	    }
#endif /* ALLOW_RIGID_POSIX_COMPLIANCE */
	  return (EXECUTION_FAILURE);
	}

      if (tt > 80)
	tt = 80;

      if (check_binary_file (string, tt))
	{
	  free (string);
	  builtin_error ("%s: cannot execute binary file", filename);
	  return (EX_BINARY_FILE);
	}

      begin_unwind_frame ("File Sourcing");

      if (list->next)
	{
	  extern void pop_dollar_vars (), push_dollar_vars ();

	  push_dollar_vars ();
	  add_unwind_protect ((Function *)pop_dollar_vars, (char *)NULL);
	  remember_args (list->next, 1);
	}

      unwind_protect_int (return_catch_flag);
      unwind_protect_jmp_buf (return_catch);

      return_catch_flag++;
      return_val = setjmp (return_catch);

      if (return_val)
	parse_and_execute_cleanup ();
      else
	result = parse_and_execute (string, filename);

      run_unwind_frame ("File Sourcing");

      /* If RETURN_VAL is non-zero, then we return the value given
	 to return_builtin (), since that is how we got here. */
      if (return_val)
	result = return_catch_value;
    }
  return (result);
}
