/* read.c, created from read.def. */
#line 23 "(null)read.def"

#line 34 "(null)read.def"

#include <stdio.h>
#include "../shell.h"

static int stream_close ();

/* Read the value of the shell variables whose names follow.
   The reading is done from the current input stream, whatever
   that may be.  Successive words of the input line are assigned
   to the variables mentioned in LIST.  The last variable in LIST
   gets the remainder of the words on the line.  If no variables
   are mentioned in LIST, then the default variable is $REPLY.

   S. R. Bourne's shell complains if you don't name a variable
   to receive the stuff that is read.  GNU's shell doesn't.  This
   allows you to let the user type random things. */
read_builtin (list)
     WORD_LIST *list;
{
  extern int interrupt_immediately, free ();
  extern SHELL_VAR *bind_variable ();
  extern char *string_list_dollar_star ();
  register char *varname;
  int size, c, i, fildes, raw_mode, pass_next;
  char *input_string, *ifs_chars;
  WORD_LIST *words, *rwords, *list_string ();
  FILE *input_stream;

  i = 0;		/* Index into the string that we are reading. */
  raw_mode = 0;		/* Not reading raw input be default. */

  ifs_chars = get_string_value ("IFS");
  input_string = (char *)xmalloc (size = 128);

  /* We need unbuffered input from stdin.  So we make a new stream with
     the same file descriptor as stdin, then unbuffer it. */
  fildes = dup (fileno (stdin));

  if (fildes == -1)
    return (EXECUTION_FAILURE);

  input_stream = fdopen (fildes, "r");

  if (!input_stream)
    {
      close (fildes);
      return (EXECUTION_FAILURE);
    }

  setbuf (input_stream, (char *)NULL);

  {
    begin_unwind_frame ("read_builtin");
    add_unwind_protect (free, input_string);
    add_unwind_protect (stream_close, input_stream);
    interrupt_immediately++;
  }

  while (list)
    {
      if (strcmp (list->word->word, "-r") == 0)
	{
	  raw_mode = 1;
	  list = list->next;
	}
      else if (strcmp (list->word->word, "--") == 0)
	{
	  list = list->next;
	  break;
	}
      else if (*list->word->word == '-')
	{
	  bad_option (list->word->word);
	  return (EXECUTION_FAILURE);
	}
      else
	break;
    }

  pass_next = 0;	/* Non-zero signifies last char was backslash. */

  while ((c = getc (input_stream)) != EOF)
    {
      if (i + 2 >= size)
	input_string = (char *)xrealloc (input_string, size += 128);

      /* If the next character is to be accepted verbatim, a backslash
	 newline pair still disappears from the input. */
      if (pass_next)
	{
	  if (c != '\n')
	    input_string[i++] = c;

	  pass_next = 0;
	  continue;
	}

      if (c == '\\' && !raw_mode)
	{
	  pass_next++;
	  continue;
	}

      if (c == '\n')
	break;

      input_string[i++] = c;
    }
  input_string[i] = '\0';

  interrupt_immediately--;
  discard_unwind_frame ("read_builtin");

  fclose (input_stream);

  if (c == EOF)
    return (EXECUTION_FAILURE);

  if (!list)
    {
      SHELL_VAR *var;

      var = bind_variable ("REPLY", input_string);
      var->attributes &= ~att_invisible;
      free (input_string);
    }
  else
    {
      words = list_string (input_string, ifs_chars, 0);
      rwords = words;

      free (input_string);

      while (list)
	{
	  SHELL_VAR *var;

	  varname = list->word->word;

	  if (!list->next)
	    {
	      /* Call string_list_dollar_star because P1003.2.9 specifies
		 that the intervening separators are preserved in the
		 result of a read that specifies fewer variables than words
		 read. */
	      char *t = words ? string_list_dollar_star (words) : "";
	      var = bind_variable (varname, t);
	    }
	  else
	    var = bind_variable (varname, words ? words->word->word : "");

	  stupidly_hack_special_variables (varname);
	  var->attributes &= ~att_invisible;

	  list = list->next;
	  if (words)
	    words = words->next;
	}
      if (rwords)
	dispose_words (rwords);
    }

  return (EXECUTION_SUCCESS);
}

/* This way I don't have to know whether fclose () is a
   function or a macro. */
static int
stream_close (file)
     FILE *file;
{
  return (fclose (file));
}
