use DB2CLI;

SQLAllocEnv($henv)				and message("AllocEnv");
SQLAllocConnect($henv, $hdbc)			and message("AllocConnect");
SQLConnect($hdbc, 'SAMPLE', 'AK', '')		and message("Connect");
SQLAllocStmt($hdbc, $hstmt)			and message("AllocStmt");

SQLPrepare($hstmt, <<)				and message("Prepare");
	SELECT * FROM ADMIN.STAFF
        WHERE salary >= ?

SQLExecute($hstmt, 20000)			and message("Execute");

SQLNumResultCols($hstmt, $ncol)			and message("NumResultsCol");
while (($r = SQLFetch($hstmt)) == 0) {
    for ($i = 1; $i <= $ncol; ++$i) {
	SQLGetData($hstmt, $i, SQL_C_CHAR, $data)   and message("GetData");
	print ',' if $i > 1;
	print defined($data) ? $data : '-';
    }
    print "\n";
}
message("Fetch", $r) if $r != SQL_NO_DATA_FOUND();

SQLFreeStmt($hstmt)				and message("FreeStmt");
SQLDisconnect($hdbc)				and message("Disconnect");
SQLFreeConnect($hdbc)				and message("FreeConnect");
SQLFreeEnv($henv)				and message("FreeEnv");

exit 0;

sub message
{
    my ($where, $retcode) = @_;
    my ($state, $native, $text);
    if (SQLError($henv, $hdbc, $hstmt, $state, $native, $text) >= 0) {
	print "$where: $state,$native: $text\n";
	exit 1;
    }
    print "$where: cannot retrieve error info, retcode=$retcode\n";
    exit 2;
}
