/* read_kbd.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

static int __read_kbd_console(HANDLE hInput, int wait)
{
    static unsigned char next_key = 0;
    unsigned char ascii;
    INPUT_RECORD ir;
    DWORD n;

    if (next_key) {
        int retv = next_key;
        next_key = 0;
        return retv;
    }

    for (;;) {

        if (!wait) // test, if there is input event
            if (GetNumberOfConsoleInputEvents(hInput, &n) == FALSE || n == 0)
                return -1;

        if (ReadConsoleInput(hInput, &ir, 1, &n) == FALSE)
            return -1;

        if (ir.EventType != KEY_EVENT)  /* not a key */
            continue;

        if (ir.Event.KeyEvent.bKeyDown != 1) /* not key down */
            continue;

        if (ir.Event.KeyEvent.uChar.AsciiChar) {
            if (ir.Event.KeyEvent.dwControlKeyState & LEFT_ALT_PRESSED) {
              ascii = 0;
              next_key = ir.Event.KeyEvent.wVirtualScanCode;
              if (next_key >= 2 && next_key <= 13)
                next_key += 118;
            }
            else
              ascii = ir.Event.KeyEvent.uChar.AsciiChar;
        }
        else {
            if (ir.Event.KeyEvent.wVirtualKeyCode >= 16     /* control,shift,alt,lock */
                && ir.Event.KeyEvent.wVirtualKeyCode <= 20)
                continue;
            if (ir.Event.KeyEvent.wVirtualKeyCode == 144    /* num-lock*/
                || ir.Event.KeyEvent.wVirtualKeyCode == 220 /* ^ */
                || ir.Event.KeyEvent.wVirtualKeyCode == 91) /* win */
                continue;
            ascii = 0;
            next_key = ir.Event.KeyEvent.wVirtualScanCode;
        }
        break;
    }

    return ascii;
}

int __read_kbd(int echo, int wait, int signal)
{
    DWORD mode;
    HANDLE hInput;
    int ascii;

    /* check Console Input Handle */
    hInput = GetStdHandle(STD_INPUT_HANDLE);
    if (hInput == INVALID_HANDLE_VALUE)
        return -1;
    else if (GetConsoleMode(hInput, &mode) == FALSE)
        return -1;

    /* disable control-c */
    SetConsoleMode(hInput, 0);

    ascii = __read_kbd_console(hInput, wait);

    SetConsoleMode(hInput, mode);

    if (echo)
        if (ascii >= 32)
            __write(1, &ascii, 1);

    if (signal && ascii == 3) {
        EMXPROCESS *proc = _rsxnt_get_process_ptr();
        _rsxnt_send_signal(proc, SIGINT);
#ifdef EMX_SYS_LIB
        _rsxnt_check_signals();
#endif
    }
    return ascii;
}
