/* ioctl2.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

/*
  Under Win32s we habe no console support
  Emulate them for EMX startup code
*/

static int _rsxnt_win32s_ioctl(int fd, int request, int arg)
{
    int *type = (int *) arg;
    *type = HT_DEV_CON;
    return 0;
}

int __ioctl2(int fd, int request, int arg)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD type;
    int *arg_ptr;

    if (fd >= N_FILES || fd < 0)
	return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
	return _rsxnt_errno(EBADF);

    if (_rsxnt_win32_version == WIN32S
	&& fd < 3 && p->file[fd].f_handle == BAD_FS_HANDLE)
	return _rsxnt_win32s_ioctl (fd, request, arg);

    if (p->file[fd].f_mode == HT_SOCKET)
    {
	if (!_rsxnt_socket_fop.ioctl)
	    return _rsxnt_errno (EBADF);
	else
	    return (*_rsxnt_socket_fop.ioctl)
	      ((int) p->file[fd].f_handle, request, arg);
    }

    type = _rsxnt_get_ht_type(p->file[fd].f_handle);

    if (request == FGETHTYPE) {
	if (type == 0xffffffff)
	    return _rsxnt_errno(EBADF);
	arg_ptr = (int *) arg;
	*arg_ptr = type;
	return 0;

    } else if (fd == 0 && type == HT_DEV_CON) {
	return _rsxnt_termio_ioctl(p, request, arg);
    } else
	return _rsxnt_errno(EINVAL);
}
