/* ioctl1.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

int __ioctl1(int fd, int request)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD type;
    int res;

    if (fd >= N_FILES || fd < 0)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);

    if (request != 0)
        return _rsxnt_errno(EINVAL);

    type = GetFileType(p->file[fd].f_handle);

    switch (type) {

        /*
        * disk file
        *  15    file is remote (DOS 3+)
        *  14    don't set file date/time on closing (DOS 3+)
        *  11    media not removable
        *   8    (DOS 4 only) generate INT 24 if no disk space on write or read past
        *          end of file
        *   7    clear (indicates file)
        *   6    file has not been written
        *  5-0   drive number (0 = A:)
        */
        case FILE_TYPE_DISK:
            res = 0;
            break;

        /*
        * character device
        *  14    device driver can process IOCTL requests (see AX=4402h)
        *  13    output until busy supported
        *  11    driver supports OPEN/CLOSE calls
        *   7    set (indicates device)
        *   6    EOF on input
        *   5    raw (binary) mode
        *   4    device is special (uses INT 29)
        *   3    clock device
        *   2    NUL device
        *   1    standard output
        *   0    standard input
        */
        case FILE_TYPE_CHAR:
            if (p->file[fd].f_handle == GetStdHandle(STD_INPUT_HANDLE))
                res = 0x81;
            else if (p->file[fd].f_handle == GetStdHandle(STD_OUTPUT_HANDLE))
                res = 0x82;
            else if (p->file[fd].f_handle == GetStdHandle(STD_ERROR_HANDLE))
                res = 0x82;
            else
                res = 0xf0;
            break;

        case FILE_TYPE_PIPE:
            res = 0x80;
            break;

        case FILE_TYPE_UNKNOWN:
        default:
            return _rsxnt_errno(EINVAL);
    }
    return res;
}
