/* getpeern.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <rsxnt.h>
#include <rsxntso.h>

int __getpeername (int fd, struct sockaddr *name, int *pnamelen)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();

    if (!_rsxnt_socket_inited)
      return _rsxnt_errno(ENETDOWN);

    if (fd >= N_FILES || fd < 0)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_mode != HT_SOCKET)
        return _rsxnt_errno(EBADF);
    else {
        if ((*wsa_getpeername) ((int)p->file[fd].f_handle, name, pnamelen) == SOCKET_ERROR)
            return _rsxnt_socket_errno();
        return 0;
    }
}
