/* alarm.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

static DWORD WINAPI alarm_thread(LPVOID lpThreadParameter)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD sec, start, end, sleepsec;

    sec = (DWORD) lpThreadParameter;

    start = GetTickCount();
    WaitForSingleObject(p->hEventAlarm, sec * 1000);
    end = GetTickCount();

    if (p->alarm_flags == ALARM_START) {
        _rsxnt_send_signal(p, SIGALRM);
        _rsxnt_do_signal(SIGALRM);
        p->hThreadAlarm = 0;
    }

    if (end < start)
        return 0;
    sleepsec = (end-start)/1000;
    if (sleepsec >= sec)
        return 0;
    else
        return (sec - sleepsec);
}

unsigned int __alarm(unsigned sec)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD tid;
    HANDLE h;
    DWORD retv;

    if (!p->hEventAlarm) {
        h = CreateEvent(NULL, FALSE, FALSE, NULL);
        if (h == INVALID_HANDLE_VALUE)
            return -1;
        else
            p->hEventAlarm = h;
    }

    /* kill old alarm */
    if (p->hThreadAlarm) {
        p->alarm_flags = ALARM_RESTART;
        PulseEvent(p->hEventAlarm);
        WaitForSingleObject(p->hThreadAlarm, INFINITE);
        GetExitCodeThread(p->hThreadAlarm, &retv);
        CloseHandle (p->hThreadAlarm);
        p->hThreadAlarm = 0;
    } else
        retv = 0;

    if (sec > 0) {
        h = CreateThread(NULL, 0, alarm_thread, (LPVOID) sec, CREATE_SUSPENDED, &tid);
        if (h == INVALID_HANDLE_VALUE)
            return -1;
        else
            p->hThreadAlarm = h;

        p->alarm_flags = ALARM_START;
        ResumeThread(p->hThreadAlarm);
    } else
        retv = 0;

    return retv;
}
