; rsxnta.asm - system interface (Intel assembler syntax)
;
; Copyright (c) 1995-1999 Rainer Schnitker
;
; This file is part of RSXNT.
;
; RSXNT is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2, or (at your option)
; any later version.
;
; RSXNT is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with RSXNT; see the file COPYING.  If not, write to
; the Free Software Foundation, 59 Temple Place - Suite 330,
; Boston, MA 02111-1307, USA. */

        .386p
        .387

L_FLAG_DLL              = 0001H                 ; Executable is a DLL
LAYOUT_TABLE    STRUC
L_TEXT_BASE     DD      ?
L_TEXT_END      DD      ?
L_DATA_BASE     DD      ?
L_DATA_END      DD      ?
L_BSS_BASE      DD      ?
L_BSS_END       DD      ?
L_HEAP_BASE     DD      ?
L_HEAP_END      DD      ?
L_HEAP_BRK      DD      ?
L_HEAP_OFF      DD      ?
L_OS2_DLL       DD      ?
L_STACK_BASE    DD      ?
L_STACK_END     DD      ?
L_FLAGS         DD      ?
L_RESERVED      DD      2 DUP (?)
L_OPTIONS       DB      64 DUP (?)
LAYOUT_TABLE    ENDS

        extrn _get_argv_env             :near
        extrn _cpy_argv_env             :near
        extrn _init_process_test_fork   :near
        extrn _init_process_fork        :near
        extrn _init_rte                 :near
        extrn _sys_call                 :near

        .data

        .code

;; The arguments and the environment are passed on the stack:
;;
;;        (high end of stack)
;;        environment and argument strings; use envp[] and argv[] for accessing
;;        argv[], NULL terminated
;; ESP->  envp[], NULL terminated


;; CAUTION do not use registers ebp, esi, edi, ebx

public RSXNT_Init
RSXNT_Init PROC
        finit
        cld

        pop     edx                 ;; return address
        pop     eax                 ;; _data line

        push    edx
        push    eax
        call    _init_process_test_fork
        mov     ecx, eax
        pop     eax
        pop     edx

        or      ecx, ecx            ;; test fork
        jz      init2
        mov     esp, ecx
        push    esp
        call    _init_process_fork
        pop     eax
        popad                       ;; return from father fork()
        popfd
        ret

init2:
        push    edx
        push    eax
        call    _init_rte
        pop     eax
        pop     edx

        test    [eax].l_flags, l_flag_dll
        jnz     return_to_app       ;; called by dll startup code

                                    ;; block:    <- ecx
        mov     ecx, esp            ;; -1 space
        sub     esp, 6*4            ;; -2 envc
        mov     eax, esp            ;; -3 argc
                                    ;; -4 env
                                    ;; -5 argv
                                    ;; -6 esp    <- eax
        push    ecx
        push    edx
        push    eax
        call    _get_argv_env
        pop     eax
        pop     edx
        pop     ecx

        sub     esp, [ecx-1*4]
        mov     [ecx-6*4], esp

        push    edx
        push    eax
        call    _cpy_argv_env
        pop     eax
        pop     edx

return_to_app:
        jmp     edx
        ret
RSXNT_Init endp

public RSXNT_Call
RSXNT_Call PROC
        pushfd
        pushad
        push    esp
        call    _sys_call
        pop     eax
        popad
        popfd
        ret
RSXNT_Call endp

      end
