/* rel.c - get relocs from a coff file

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <io.h>
#include "ntbind.h"

#define ROUNDUP(x, size) (((x)+(size-1))&(~(size-1)))

struct relocs {
  unsigned long r_vaddr __attribute__((packed));
  unsigned long r_symndx __attribute__((packed));
  unsigned short r_type;
};

typedef struct external_syment
{
  union {
    char e_name[8];
    struct {
      unsigned long e_zeroes __attribute__((packed));
      unsigned long e_offset __attribute__((packed));
    } e;
  } e;
  unsigned long e_value __attribute__((packed));
  short e_scnum;
  unsigned short e_type;
  unsigned char e_sclass;
  unsigned char e_numaux;
} SYMENT;

static int show_relocs(char * coff_file)
{
    FILEHDR         file_hdr;
    AOUTHDR         aout_hdr;
    SCNHDR          scn_hdr[5];
    int             coffhandle;

    SYMENT          *symtab, *sym;
    struct relocs   *reloc;
    char            *strtab;
    int             i, size, sec;
    long            strsize;

    if ((coffhandle = open(coff_file, O_RDONLY | O_BINARY)) == -1) {
        perror(coff_file);
        return -1;
    }

    read(coffhandle, &file_hdr, sizeof(FILEHDR));
    if (file_hdr.f_magic != 0x14C) {
        close(coffhandle);
        return 1;
    }
    read(coffhandle, &aout_hdr, sizeof(AOUTHDR));
    read(coffhandle, &scn_hdr, sizeof(SCNHDR) * file_hdr.f_nscns);

    /* readin symbols */
    size = file_hdr.f_nsyms * sizeof(SYMENT);
    sym = symtab = (SYMENT *) malloc (size);
    lseek (coffhandle, file_hdr.f_symptr, 0);
    read (coffhandle, symtab, size);

    read(coffhandle, &strsize, sizeof (long));
    strtab = (char *) malloc(strsize);
    read(coffhandle, strtab + 4, strsize-4);
    strtab[0] = 0;

#if 0
    for (i = 0; i < file_hdr.f_nsyms; i++) {
        if (sym->e.e.e_zeroes == 0)
            printf("%s\n", strtab + sym->e.e.e_offset);
        else
            puts(sym->e.e_name);

        ++sym;
    }
#endif

    for (sec = 0; sec < file_hdr.f_nscns; ++sec) {

        printf("---------- relocs of section %d ----------\n",
                sec);

        size = sizeof (struct relocs) * scn_hdr[sec].s_nreloc;

        if (size) {
            /* readin section */
            reloc = (struct relocs *) malloc (size);
            lseek (coffhandle, scn_hdr[sec].s_relptr, 0);
            read (coffhandle, reloc, size);

            for (i = 0; i < scn_hdr[sec].s_nreloc; i++)
                if (reloc->r_type == 6) {
                    printf("%8lX %5lX %2X --> ",
                        reloc[i].r_vaddr,
                        reloc[i].r_symndx,
                        reloc[i].r_type);
                    printf("val: %8lX\n", symtab[reloc[i].r_symndx].e_value);
                }
            free (reloc);
        }
    }
    close(coffhandle);
    return 0;
}

int main(int argc, char **argv)
{
    static char usage_text[] =
        "usage:\n"
        " reloc coff-file\n";

    if (argc != 2) {
        puts(usage_text);
        return -1;
    }

    return show_relocs(argv[1]);
}
