/* begintex.c - MSC extented version of _beginthread()

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <emx/syscalls.h>
#include <emx/thread.h>
#include <mscompat.h>

#define WIN32_LEAN_AND_MEAN
#include <wingnuc.h>
#include <windows.h>
#include <winerror.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifndef __MT__
#error Must define __MT__ for multithread library.
#endif

extern int __thread_init();
extern struct _thread __thread_1;
extern unsigned long __ThreadIndex;

typedef void (*cdecl_thread_func) (void *);
typedef unsigned long __stdcall (*stdcall_thread_func) (void *);

static DWORD WINAPI thread_start (void * param)
{
    struct _thread *tp = (struct _thread *) param;
    stdcall_thread_func tf;

    TlsSetValue(__ThreadIndex, tp);   /* set thread local storage */

    tf = (stdcall_thread_func) tp->_th_start;

    _endthreadex (tf(tp->_th_arg));

    /* Never executed! */
    return 0L;
}

/*
    Differences between _beginthread()/_endthread():

    1) parameter for CreateThread
    2) thread function has return code
    3) _endthread() does not close the thread handle
    4) _beginthreadex return FALSE not -1
*/

unsigned long _beginthreadex(
    void *      security,
    unsigned    stack_size,
    unsigned __stdcall (*start) (void *),
    void *      arg_list,
    unsigned    init_flag,
    unsigned *  tid)
{
    struct _thread *tp;
    HANDLE hThread;

    if (!__thread_init()) {
        errno = ENOSYS;
        return FALSE;
    }

    tp = (struct _thread *) HeapAlloc(GetProcessHeap(),
                    HEAP_ZERO_MEMORY, sizeof(struct _thread));

    if (!tp) {
        errno = ENOMEM;
        return FALSE;
    }

    tp->_th_rand = 1;
    tp->_th_start = (cdecl_thread_func) start;
    tp->_th_arg = arg_list;

    hThread = CreateThread (security, stack_size, thread_start, (void *) tp,
                CREATE_SUSPENDED, (LPDWORD) &tid);

    if (hThread == 0) {
        errno = EINVAL;
        return FALSE;
    }

    if (__newthread (*tid) != 0) {       /* system call */
        TerminateThread(hThread, 0);
        return FALSE;
    }

    if (init_flag != CREATE_SUSPENDED)
        if (ResumeThread(hThread) == FALSE) {
            errno = ESRCH;
            return FALSE;
        }
    return (unsigned long) hThread;
}

void _endthreadex (unsigned retval)
{
    struct _thread *tp;

    if (!__thread_init())
        return;

    tp = _thread ();

    if (tp != & __thread_1) {               /* not main thread */
        HeapFree(GetProcessHeap(), 0, tp);
        __endthread (_gettid());            /* system call */
        ExitThread(retval);
    }
    ExitProcess(retval);
}

