/* assert.c - Defines assert() function for GUI and console progs

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <wingnuc.h>
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <alloca.h>

void _assert (const char *string, const char *fname, unsigned int line)
{
    DWORD mode;

    if (GetConsoleMode(GetStdHandle(STD_ERROR_HANDLE), &mode) == FALSE)
    {
        char * tmp = (char *) alloca (100 + strlen (string));
        wsprintf (tmp, "Assertion failed!\n\n"
                       "File: %s\n"
                       "Line: %u\n\n"
                       "Expression: %s\n\n"
                       "Abort the program?",
                            fname, line, string);
        if (MessageBox (NULL, tmp, "RSXNT runtime library                   ",
                                    MB_YESNO|MB_ICONERROR|MB_TASKMODAL) != IDNO)
          abort ();
    }
    else
    {
        fprintf (stderr, "Assertion failed: %s, file %s, line %u\n", string, fname, line);
        fflush (stderr);
        abort ();
    }
}

