/*  emxinc.c:
      reads scripts longshrt.ls1[2] from \emx\include
      to convert C++ headers to long filenames

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int read_line (FILE * inp, char *pszLine, int iMax)
{
  int c;
  int iPos = 0;
  pszLine[0] = 0;

  for (;;)
    {
      switch (c = fgetc (inp))
        {
        case ';':
          while (((c = fgetc (inp)) != '\n') && (c != EOF)) ;
        case '\n':
          if (!iPos)
            break;
        case EOF:
          pszLine[iPos] = 0;
          return iPos;
        case ' ':
          if (!iPos)
            break;
          if (pszLine[0] == ':')
            {
              pszLine[iPos] = 0;
              return iPos;
            }
          if (pszLine[iPos - 1] == ' ')
            break;
        default:
          if (iPos >= iMax)
            {
              exit (1);
            }
          pszLine[iPos++] = (char) c;
          break;
        }
    }
}

int make_argv (char *cline, char **argvec)
{
  int argc;                     // arguments
  int src;                      // source pointer
  int dst;                      // dest pointer
  int bs;                       // backspace count
  int quote;                    // quote
  char *q;                      // argument ptr

  argc = 0;
  dst = src = 0;

  // skip leading blanks
  while (cline[src] == ' ' || cline[src] == '\t' || cline[src] == '\n')
    ++src;
  do
    {
      if (cline[src] == 0)
        q = NULL;
      else
        {
          q = cline + dst;
          bs = 0;
          quote = 0;

          for (;;)
            {
              if (cline[src] == '"')
                {
                  while (bs >= 2)
                    {
                      cline[dst++] = '\\';
                      bs -= 2;
                    }
                  if (bs & 1)
                    cline[dst++] = '"';
                  else
                    quote = !quote;
                  bs = 0;
                }
              else if (cline[src] == '\\')
                ++bs;
              else
                {
                  while (bs != 0)
                    {
                      cline[dst++] = '\\';
                      --bs;
                    }
                  if (cline[src] == 0 ||
                      ((cline[src] == ' ' || cline[src] == '\t') && !quote))
                    break;
                  cline[dst++] = cline[src];
                }
              ++src;
            }
          while (cline[src] == ' ' || cline[src] == '\t'
                 || cline[src] == '\n')
            ++src;
          cline[dst++] = 0;
        }
      argvec[argc++] = q;
    }
  while (q != NULL);

  return argc - 1;
}

void error (char *text)
{
  fputs (text, stderr);
  exit (1);
}

int main ()
{
  char buf[512];
  FILE *f;
  char olddir[260];

  getcwd (olddir, sizeof (olddir));

  _searchenv ("sed.exe", "PATH", buf);
  if (buf[0] == 0)
    error ("sed not found");

  // renaming files
  f = fopen ("longshrt.ls1", "rt");
  if (f)
    {
      while (read_line (f, buf, sizeof (buf)))
        {
          char *argv[5];
          char *s, *f;

          make_argv (buf, argv);
          s = strrchr (argv[0], '/');
          if (!s)
            s = strrchr (argv[0], '\\');
          if (s)
            *s = 0;
          f = (s) ? s + 1 : argv[0];

          if (s == NULL || chdir(argv[0]) == 0)
            {
              printf ("rename %s to %s\n", argv[1], f);
              rename (argv[1], f);
              chdir (olddir);
            }
          else
            printf("cannot change to directory %s\n", argv[0]);
        }
      fclose (f);
    }
  else
  {
    fputs ("emxinc: patching emx include headers (C++ with long filenames)\n"
            "run this program in the \\emx\\include directory\n", stderr);
    error ("cannot open longshrt.ls1");
  }    
  // patching files
  f = fopen ("longshrt.ls2", "rt");
  if (f)
    {
      while (read_line (f, buf, sizeof (buf)))
        {
          char buf2[512];
          char *s, *f;

          s = strrchr (buf, '/');
          if (!s)
            s = strrchr (buf, '\\');
          if (s)
            *s = 0;
          f = (s) ? s + 1 : buf;

          if (s == NULL || chdir(buf) == 0)
            {
              if (access (f, 0) == 0)
              {
                printf ("patching %s\n", f);

                sprintf (buf2, "sed -f %s\\long.sed %s >tmp", olddir, f);
                system (buf2);

                sprintf (buf2, "touch -r %s tmp", f);
                system (buf2);

                remove (f);

                sprintf (buf2, "move tmp %s >nul", f);
                system (buf2);

              }
              else
              {
                printf ("file not found: %s\n", f);
              }
              chdir (olddir);
            }
        }
      fclose (f);
    }
  else
    error ("error: cannot open longshrt.ls2");
  return 0;
}
