/* splithtm.c - split emx html helpfile, build HHW help files
                basename.hhp, basename.hhc, basename.hhk

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

static int readline (FILE * fh, char *buf)
{
  int c;
  int i = 0;

  while ((c = fgetc (fh)) != EOF)
    {
      if (c == '\r')
        continue;
      if (c == '\n')
        break;

      /* emx docs uses oem code page */
      /* convert table chars */
      if (c == 0xb3) c = '|';
      else if (c == 0xc4) c = '-';
      else if (c == 0xc5) c = '+';
      
      buf[i] = (char) c;
      ++i;
    }
  buf[i] = 0;
  return (c == EOF) ? -1 : i;
}

static int split_html (const char *filename, const char *basename)
{
  FILE *fin, *fout, *fhhk, *fhhc, *fhhp, *fstart;
  char * line;
  char fname[260];
  int startf = 1;
  int heading = 1;
    
  fin = fopen (filename, "r");
  if (!fin)
    return 1;
  line = (char *) malloc(4096);

  sprintf (fname, "%s_start.htm", basename);
  fout = fopen (fname, "w");
  if (!fout)
    return 1;

  sprintf (fname, "%s.%s", basename, "hhk");
  fhhk = fopen (fname, "w");
  if (!fhhk)
    return 1;
  fprintf (fhhk, "<HTML>\n");
  fprintf (fhhk, "<!--Sitemap 1.0-->\n");
  fprintf (fhhk, "<OBJECT type=\"text/site properties\">");
  fprintf (fhhk, "</OBJECT>\n");
  fprintf (fhhk, "<UL>\n");

  sprintf (fname, "%s.%s", basename, "hhc");
  fhhc = fopen (fname, "w");
  if (!fhhc)
    return 1;
  fprintf (fhhc, "<HTML>\n");
  fprintf (fhhc, "<!--Sitemap 1.0-->\n");
  fprintf (fhhc, "<OBJECT type=\"text/site properties\">");
  fprintf (fhhc, "</OBJECT>\n");
  fprintf (fhhc, "<UL>\n");

  sprintf (fname, "%s.hhp", basename);
  fhhp = fopen (fname, "w");
  if (!fhhp)
    return 1;
  fprintf (fhhp, "[OPTIONS]\n");
  fprintf (fhhp, "Compatibility=1.1 or later\n");
  fprintf (fhhp, "Compiled file=%s.chm\n", basename);
  fprintf (fhhp, "Contents file=%s.hhc\n", basename);
  fprintf (fhhp, "Default topic=%s_start.htm\n", basename);
  fprintf (fhhp, "Display compile progress=No\n");
  fprintf (fhhp, "Index file=%s.hhk\n", basename);
  fprintf (fhhp, "Language=0x409 Englisch (USA)\n");
  fprintf (fhhp, "Title=emx help file\n\n");
  fprintf (fhhp, "[FILES]\n");
  fprintf (fhhp, "%s_start.htm\n", basename);

  while (readline (fin, line) >= 0)
    {
      char *p;
      if ((p = strstr (line, "<A NAME=")) != 0)
        {
          long l;
          p += 9;
          l = atol (p);
          if (l)
            {
              char *text, *e;
              
              fprintf (fhhp, "%s%ld.htm\n", basename, l); /* project entry */
              if (!startf)
                fputs ("</BODY></HTML>\n", fout);
              else
                startf = 0;
              fclose (fout);
              
              readline (fin, line);             
              sprintf (fname, "%s%ld.htm", basename, l);
              fout = fopen (fname, "w");
              fputs ("<HTML><HEAD>\n", fout);
              fprintf (fout, "<TITLE>%s</TITLE>", line);
              fputs ("</HEAD><BODY>\n", fout);
              fputs (line, fout);
              fputs ("\n", fout);

              sprintf (fname, "%s_start.htm", basename);
              fstart = fopen (fname, "a");
              fprintf (fstart, "<A HREF=\"%s%ld.htm\">", basename, l);
              fputs (line, fstart);
              fputs ("</A>\n", fstart);
              fclose (fstart);

              e = strstr (line, "<H"); /* search <H?> */
              if (e && e[2] >= '0' && e[2] <= '9')
              {
                int h = atoi (e+2);
                if (h > heading)
                  fprintf (fhhc, "<UL>\n");
                else if (h < heading)
                {
                  int h2 = h;
                  while (h2++ < heading)                  
                    fprintf (fhhc, "</UL>\n");
                }
                heading = h;
              }
              
              text = line;
              while (*text == '<')
                text = strchr (text, '>') + 1;
              e = strchr (text, '<');
              if (e)
                *e = 0;
              fprintf (fhhc, "<LI><OBJECT type=\"text/sitemap\">\n");
              fprintf (fhhc, "<param name=\"Name\" value=\"%s\">\n", text);
              fprintf (fhhc, "<param name=\"Local\" value=\"%s%ld.htm\">\n", basename, l);
              fprintf (fhhc, "</OBJECT>\n");
              fprintf (fhhc, "<A HREF=\"%s%ld.htm\">%s</A><BR>\n", basename, l, text);
            }
        }
      else
        {
          char *check = line;

          while (check)
            {
              if ((p = strstr (check, "<A HREF=\"")) != 0)
                {
                  /* <A HREF="#123"> */
                  /* <A HREF="other.html#123"> */
                  char *e, *name;
                  long l;
                  char *end = strstr (check, "\">");
                  *end = 0;
                  if (p != check)  /* write begin of line */
                  {
                    *p = 0;
                    fputs (check, fout);
                  }
                  check = end + 2;
                 
                  e = strchr (p + 9, '#');
                  *e = 0;
                  e++;
                  l = atol (e);

                  name = strchr(p + 9, '.');
                  if (name) /* name of html */
                  {
                    * name = 0;
                    name = p + 9;
                  }
                  else
                    name = "";

                  /* perhaps we must jump to the form "ms-its:filename.chm::/topic.htm" */
                  /* old form: "mk:@MSITStore:filename.chm::/topic.htm" */
                  if (*name == 0 || strcmp (name, basename) == 0)
                    fprintf (fout, "<A HREF=\"%s%ld.htm\">", basename, l);
                  else
                    fprintf (fout, "<A HREF=\"ms-its:%s.chm::/%s%ld.htm\">", name, name, l);
                  
                  if (*check != '<') /* keyword */
                    {
                      char *x = strstr (check, "</A>");
                      char old = 0;
                      if (x)
                      {
                        old = *x;
                        *x = 0;
                      }
                      fprintf (fhhk, "<LI><OBJECT type=\"text/sitemap\">\n");
                      fprintf (fhhk, "<param name=\"Keyword\" value=\"%s\">\n", check);
                      if (*name == 0 || strcmp (name, basename) == 0)
                        fprintf (fhhk, "<param name=\"Local\" value=\"%s%ld.htm\">\n", basename, l);
                      else
                        fprintf (fhhk, "<param name=\"Local\" value=\"ms-its:%s.chm::/%s%ld.htm\">\n", name, name, l);
                      fprintf (fhhk, "</OBJECT>\n");
                      /* fprintf (fhhk, "<A HREF=\"%s%ld.htm\">%s</A><BR>\n", basename, l, check); */
                      if (*name == 0 || strcmp (name, basename) == 0)
                        fprintf (fhhk, "<A HREF=\"%s%ld.htm\">", basename, l);
                      else
                        fprintf (fhhk, "<A HREF=\"ms-its:%s.chm::/%s%ld.htm\">", name, name, l);
                      fprintf (fhhk, "%s</A><BR>\n", check);

                      if (x)
                        *x = old;
                    }
                }
              else
                {
                  fputs (check, fout);
                  fputs ("\n", fout);
                  check = 0;
                }
            }
        }
    }

  sprintf (fname, "%s_start.htm", basename);
  fstart = fopen (fname, "a");
  fputs ("</HEAD><BODY>\n", fstart);
  fclose (fstart);

  fprintf (fhhk, "</UL>\n");
  fprintf (fhhk, "</HTML>\n");
  fclose (fhhk);

  while (heading-- > 1)                  
    fprintf (fhhc, "</UL>\n");
  fprintf (fhhc, "</UL>\n");
  fprintf (fhhc, "</HTML>\n");
  fclose (fhhc);

  fclose (fhhp);
  free(line);
  return 0;
}

int main (int argc, char **argv)
{
  if (argc > 1)
    {
      char basename[260];
      char *p;
      strcpy (basename, argv[1]);
      p = strrchr (basename, '.');
      if (p)
        *p = 0;
      p = strrchr (basename, '\\');
      if (!p)
        p = strrchr (basename, '/');
      if (!p)
        p = basename;
      else
        ++p;
      return split_html (argv[1], p);
    }
  else
  {
    fprintf (stderr, "Usage: %s <emx html file>\n", argv[0]);
    return 1;
  }
}

