/*----------------------------------------------------------------------*
 * Bounds Checking for GCC.						*
 * Copyright (C) 1995 Richard W.M. Jones <rjones@orchestream.com>.	*
 *----------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify	*
 * it under the terms of the GNU General Public License as published by	*
 * the Free Software Foundation; either version 2 of the License, or	*
 * (at your option) any later version.					*
 *									*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 * GNU General Public License for more details.				*
 *									*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software		*
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*
 *----------------------------------------------------------------------*
 * File:
 *	lib/objects.h
 * Summary:
 *	Format of the tree of memory objects used by the library.
 * Other notes:
 *	This file is shared with `tree/buildtree.c'.
 * Author      	Date		Notes
 * RWMJ		13/1/95		Copied this out of `bounds-lib.h'
 * RWMJ		9/2/95		Modified slightly for use with splay trees.
 *----------------------------------------------------------------------*/

#ifndef _BOUNDS_OBJECT_H_
#define _BOUNDS_OBJECT_H_

typedef enum {			/* Storage class. */
  obj_sclass_static,		/* Static, ie. global in low memory. */
  obj_sclass_external,		/* External objects */
  obj_sclass_stack,		/* On the stack. */
  obj_sclass_heap		/* On the heap. */
} obj_sclass;

typedef struct object {
  struct object *left, *right;	/* Left/right in tree. */
  struct object *parent;	/* Parent of this tree (NULL if root). */
  struct object *heap_next;	/* next heap object */
  unsigned left_of_parent : 1;	/* Whether on left or right of parent. */
  void *base;			/* Points to base of the object. */
  size_t size;			/* Size of the object. */
  void *extent;			/* Points to last byte in object + 1. */
  size_t align;			/* Size of elements in the object. */
  obj_sclass sclass;		/* Storage class. */
  char *filename;		/* Place where object was constructed. */
  int line;
  char *name;			/* Name of the object. */
  char *alloca_function;	/* If allocated by alloca, this is the name
				 * of the function where it came from. */
  unsigned no_padding : 1;	/* This is for parameters where no padding
				 * bytes are added after the object. */
  unsigned align_mask : 1;	/* Flag is set is align is power of two */
  unsigned hits;		/* Number of time this object has been found
				 * by tree_lookup or tree_lookup_base fns. */
  unsigned steps;               /* maximum steps to find object */

} object;

/* This structure describes a whole splay tree. The root node in a splay
 * tree changes often.
 */
typedef struct {
  object *root;
} tree;

#endif /* _BOUNDS_OBJECT_H_ */
