/* c16test1.c (emx+gcc) */

/* Call 16-bit function linked at load time. */

#include <stdio.h>
#include <os2thunk.h>

short _THUNK_C_FUNCTION (add) (short x, short y);

short add (int x, int y)
{
  return ((short)(_THUNK_C_PROLOG (2+2);
                  _THUNK_C_SHORT (x);
                  _THUNK_C_SHORT (y);
                  _THUNK_C_CALL (add)));
}


/* Complain if the ES register has been modified.  I forgot to save
   and restore ES in _emx_thunk1(). */

static void check_es (void)
{
  unsigned short ds, es;

  __asm__ ("movw %%ds, %0;"
           "movw %%es, %1"
           : "=r"(ds), "=r"(es) : );
  if (ds != es)
    {
      __asm__ ("push %ds;"
               "pop %es");
      printf ("Segment register ES modified!!!\n");
    }
}


int main (void)
{
  int sum;

  sum = add (2, 3);
  check_es ();
  printf ("2+3=%d\n", sum);
  return 0;
}
