/* sched.h -- changed for emx by Eberhard Mattes -- Nov 1994 */
#ifndef _LINUX_SCHED_H
#define _LINUX_SCHED_H

#include <linux/signal.h>
#include <linux/math_emu.h>

#ifndef NULL
#define NULL ((void *) 0)
#endif

struct i387_soft_struct {
	long	cwd;
	long	swd;
	long	twd;
	long	fip;
	long	fcs;
	long	foo;
	long	fos;
	long	top;
	struct fpu_reg	regs[8];	/* 8*16 bytes for each FP-reg = 128 bytes */
	unsigned char	lookahead;
	struct info	*info;
	unsigned long	entry_eip;
};

union i387_union {
	struct i387_soft_struct soft;
};

struct tss_struct {
	unsigned long	trap_no, error_code;
	union i387_union i387;
};
struct task_struct {
	unsigned long flags;	/* per process flags, defined below */
	unsigned short used_math;
	int pnum;
	struct tss_struct tss;
};

#define PF_PTRACED	0x00000010	/* set if ptrace (0) has been called. */

extern struct task_struct *current;

#define need_resched 0

#endif
