/* vputline.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

void v_putline (const char *src, int x, int y, int count)
{
  if (count > 0)
    {
#if defined (IF_OS2)
      IF_OS2
        {
          VioWrtCellStr ((PCH)src, (USHORT)(2 * count),
                         (USHORT)y, (USHORT)x, 0);
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          if (_v_mem != NULL)
            memcpy (_v_mem + (y * _v_width + x) * 2, src, (size_t)(count * 2));
          else
            {
              union REGS r;
              int i;

              for (i = 0; i < count; ++i)
                {
                  r.h.ah = 0x02;
                  r.h.bh = 0;
                  r.h.dl = x + i;
                  r.h.dh = y;
                  _int86 (0x10, &r, &r);
                  r.h.ah = 0x09;
                  r.h.bh = 0;
                  r.h.al = src[0];
                  r.h.bl = src[1];
                  r.x.cx = 1;
                  _int86 (0x10, &r, &r);
                  src += 2;
                }
              r.h.ah = 0x02;
              r.h.bh = 0;
              r.h.dl = (unsigned char)_v_x;
              r.h.dh = (unsigned char)_v_y;
              _int86 (0x10, &r, &r);
            }
        }
#endif
    }
}
