/* utime.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <time.h>
#include <sys/time.h>
#include <sys/utime.h>
#include <emx/time.h>
#include <emx/syscalls.h>

int _utime (const char *name, const struct utimbuf *times)
{
  struct timeval tv[2];

  if (times == NULL)
    {
      tv[0].tv_sec = tv[1].tv_sec = time (NULL);
      tv[0].tv_usec = tv[1].tv_usec = 0;
    }
  else
    {
      tv[0].tv_sec = times->actime;
      tv[0].tv_usec = 0;
      tv[1].tv_sec = times->modtime;
      tv[1].tv_usec = 0;
    }
  if (!_tzset_flag) _tzset ();
  _gmt2loc (&tv[0].tv_sec);
  _gmt2loc (&tv[1].tv_sec);
  return __utimes (name, tv);
}
