;;; vxrexx-doc.el --- VXREXX completion and docs for use with rexx-mode.el
;; Copyright (C) 1994 Scott Maxwell

;; Maintainer: Scott Maxwell - scottmax@netcom.com
;; Keywords: rexx vxrexx

;; To add VX-Rexx commands to your completion and documentation table, add
;; vxrexx-doc to your rexx-additional-doc-files line in your .emacs.  If
;; you only have completion/doc files for VX-Rexx and OS/2 external commands,
;; the line should look like this:
;;	(setq rexx-additional-doc-files '("rexx-os2"
;;					  "vxrexx-doc"))
;;
;; If you have other packages as well, just add them to the list like this:
;;	(setq rexx-additional-doc-files '("rexx-os2"
;;					  "rexxbase-doc"
;;					  "vxrexx-doc"))
;; You may have to reload Emacs for your changes to take affect.
;;
;; This package adds all VX-Rexx external function, method and property
;; names as of the VX-Rexx 2.0b release.  The method and property names
;; will only appear in quotes (single or double).  If you type "a" followed
;; by [Ctrl-Tab] outside of quotes you will probably see the following list:
;;   abbrev abs address arg
;;
;; Now type the same thing right after a double quote(") and you
;; will probably see:
;;   accept activate addfield addrecord addsharedrecord
;;   addstring addstringlist arrange

;; Finally, after a single quote(') you should see everything, i.e.:
;;   abbrev abs accept activate addfield addrecord address
;;   addsharedrecord addstring addstringlist arg arrange



(setq rexx-external-function-table
      (append
       '(
	 ("accelerator" . ("Accelerator" "VX-Rexx property" nil t))
	 ("accept" . (nil "VX-Rexx method for DDEClient" "Syntax:
  ok=VRMethod( object, \"Accept\", [conversation])

Description:
  Establishes a conversation with a DDE server.

Arguments:
  conversation	The conversation number to accept, as returned by the Initiate
		method.  If ommitted, the first conversation is accepted.

Returns:
  1 if successful; 0 if not

See also:
  Initiate, Terminate" t))
	 ("activate" . (nil "VX-Rexx method" "ok=VRMethod(window,\"Activate\")" t))
	 ("addfield" . ("AddField" "VX-Rexx method" nil t))
	 ("addrecord" . ("AddRecord" "VX-Rexx method" nil t))
	 ("addrecordlist" . ("AddRecordList" "VX-Rexx method" nil t))
	 ("addsharedrecord" . ("AddSharedRecord" "VX-Rexx method" nil t))
	 ("addstring" . ("AddString" "VX-Rexx method" nil t))
	 ("addstringlist" . ("AddStringList" "VX-Rexx method" nil t))
	 ("adjustheight" . ("AdjustHeight" "VX-Rexx property" nil t))
	 ("allowdrag" . ("AllowDrag" "VX-Rexx property" nil t))
	 ("alwaysupdate" . ("AlwaysUpdate" "VX-Rexx property" nil t))
	 ("arrange" . (nil "VX-Rexx method" nil t))
	 ("autoposition" . ("AutoPosition" "VX-Rexx property" nil t))
	 ("autoscroll" . ("AutoScroll" "VX-Rexx property" nil t))
	 ("autosize" . ("AutoSize" "VX-Rexx property" nil t))
	 ("autosort" . ("AutoSort" "VX-Rexx property" nil t))
	 ("autotab" . ("AutoTab" "VX-Rexx property" nil t))
	 ("backcolor" . ("BackColor" "VX-Rexx property" nil t))
	 ("backpages" . ("BackPages" "VX-Rexx property" nil t))
	 ("binding" . (nil "VX-Rexx property" nil t))
	 ("border" . (nil "VX-Rexx property" nil t))
	 ("bordercolor" . ("BorderColor" "VX-Rexx property" nil t))
	 ("bordersize" . ("BorderSize" "VX-Rexx property" nil t))
	 ("bordertype" . ("BorderType" "VX-Rexx property" nil t))
	 ("cancel" . (nil "VX-Rexx property" nil t))
	 ("caption" . (nil "VX-Rexx property" nil t))
	 ("captionseparator" . ("CaptionSeparator" "VX-Rexx property" nil t))
	 ("centerwindow" . ("CenterWindow" "VX-Rexx method" nil t))
	 ("checked" . (nil "VX-Rexx property" nil t))
	 ("checkhandles" . ("CheckHandles" "VX-Rexx property" nil t))
	 ("clear" . (nil "VX-Rexx method" nil t))
	 ("columns" . (nil "VX-Rexx property" nil t))
	 ("commandline" . ("CommandLine" "VX-Rexx property" nil t))
	 ("copy" . (nil "VX-Rexx method" nil t))
	 ("count" . (nil "VX-Rexx property" nil t))
	 ("cut" . (nil "VX-Rexx method" nil t))
	 ("dbcsconversionbar" . ("DBCSConversionBar" "VX-Rexx property" nil t))
	 ("default" . (nil "VX-Rexx property" nil t))
	 ("defaultitem" . ("DefaultItem" "VX-Rexx property" nil t))
	 ("delay" . (nil "VX-Rexx property" nil t))
	 ("delete" . (nil "VX-Rexx method" nil t))
	 ("deletelist" . ("DeleteList" "VX-Rexx method" nil t))
	 ("deletepage" . ("DeletePage" "VX-Rexx method" nil t))
	 ("deletestring" . ("DeleteString" "VX-Rexx method" nil t))
	 ("deselect" . (nil "VX-Rexx method" nil t))
	 ("deselectlist" . ("DeselectList" "VX-Rexx method" nil t))
	 ("detailsort" . ("DetailSort" "VX-Rexx property" nil t))
	 ("disableundo" . ("DisableUndo" "VX-Rexx property" nil t))
	 ("dragtarget" . ("DragTarget" "VX-Rexx property" nil t))
	 ("enabled" . (nil "VX-Rexx property" nil t))
	 ("execute" . (nil "VX-Rexx method" nil t))
	 ("extendselect" . ("ExtendSelect" "VX-Rexx property" nil t))
	 ("fastspin" . ("FastSpin" "VX-Rexx property" nil t))
	 ("fillfromdir" . ("FillFromDir" "VX-Rexx method" nil t))
	 ("findrecord" . ("FindRecord" "VX-Rexx method" nil t))
	 ("findstring" . ("FindString" "VX-Rexx method" nil t))
	 ("firstchild" . ("FirstChild" "VX-Rexx property" nil t))
	 ("firstrecord" . ("FirstRecord" "VX-Rexx property" nil t))
	 ("flowed" . (nil "VX-Rexx property" nil t))
	 ("font" . (nil "VX-Rexx property" nil t))
	 ("forecolor" . ("ForeColor" "VX-Rexx property" nil t))
	 ("frameowner" . ("FrameOwner" "VX-Rexx property" nil t))
	 ("getactivewindow" . ("GetActiveWindow" "VX-Rexx method" nil t))
	 ("getattributes" . ("GetAttributes" "VX-Rexx method" nil t))
	 ("getclipboard" . ("GetClipboard" "VX-Rexx method" nil t))
	 ("getfieldattr" . ("GetFieldAttr" "VX-Rexx method" nil t))
	 ("getfielddata" . ("GetFieldData" "VX-Rexx method" nil t))
	 ("getfocuswindow" . ("GetFocusWindow" "VX-Rexx method" nil t))
	 ("getitemdata" . ("GetItemData" "VX-Rexx method" nil t))
	 ("getitemdatalist" . ("GetItemDataList" "VX-Rexx method" nil t))
	 ("getpagenumber" . ("GetPageNumber" "VX-Rexx method" nil t))
	 ("getpagewindow" . ("GetPageWindow" "VX-Rexx method" nil t))
	 ("getprocessid" . ("GetProcessID" "VX-Rexx method" nil t))
	 ("getrecordattr" . ("GetRecordAttr" "VX-Rexx method" nil t))
	 ("getrecordlist" . ("GetRecordList" "VX-Rexx method" nil t))
	 ("getselectedlist" . ("GetSelectedList" "VX-Rexx method" nil t))
	 ("getselectedstringlist" . ("GetSelectedStringList" "VX-Rexx method" nil t))
	 ("getstatustext" . ("GetStatusText" "VX-Rexx method" nil t))
	 ("getstring" . ("GetString" "VX-Rexx method" nil t))
	 ("getstringlist" . ("GetStringList" "VX-Rexx method" nil t))
	 ("gettabtext" . ("GetTabText" "VX-Rexx method" nil t))
	 ("getthreadid" . ("GetThreadID" "VX-Rexx method" nil t))
	 ("getticklabels" . ("GetTickLabels" "VX-Rexx method" nil t))
	 ("getticksizes" . ("GetTickSizes" "VX-Rexx method" nil t))
	 ("getvar" . ("GetVar" "VX-Rexx method" nil t))
	 ("haltthread" . ("HaltThread" "VX-Rexx method" nil t))
	 ("height" . (nil "VX-Rexx property" nil t))
	 ("helpfile" . ("HelpFile" "VX-Rexx property" nil t))
	 ("helptag" . ("HelpTag" "VX-Rexx property" nil t))
	 ("helptext" . ("HelpText" "VX-Rexx property" nil t))
	 ("helptitle" . ("HelpTitle" "VX-Rexx property" nil t))
	 ("hidebutton" . ("HideButton" "VX-Rexx property" nil t))
	 ("hilitecolor" . ("HiliteColor" "VX-Rexx property" nil t))
	 ("hinttext" . ("HintText" "VX-Rexx property" nil t))
	 ("homeposition" . ("HomePosition" "VX-Rexx property" nil t))
	 ("horizscroll" . ("HorizScroll" "VX-Rexx property" nil t))
	 ("hwnd" . ("HWnd" "VX-Rexx property" nil t))
	 ("iconheight" . ("IconHeight" "VX-Rexx property" nil t))
	 ("iconwidth" . ("IconWidth" "VX-Rexx property" nil t))
	 ("ignoretab" . ("IgnoreTab" "VX-Rexx property" nil t))
	 ("imagepushbutton" . ("ImagePushButton" "VX-Rexx property" nil t))
	 ("imageradiobutton" . ("ImageRadioButton" "VX-Rexx property" nil t))
	 ("index" . (nil "VX-Rexx property" nil t))
	 ("initiallist" . ("InitialList" "VX-Rexx property" nil t))
	 ("initialpagelist" . ("InitialPageList" "VX-Rexx property" nil t))
	 ("initiate" . (nil "VX-Rexx method" nil t))
	 ("insert" . (nil "VX-Rexx method" nil t))
	 ("insertblankpage" . ("InsertBlankPage" "VX-Rexx method" nil t))
	 ("insertpage" . ("InsertPage" "VX-Rexx method" nil t))
	 ("installaccelerators" . ("InstallAccelerators" "VX-Rexx method" nil t))
	 ("interiorheight" . ("InteriorHeight" "VX-Rexx property" nil t))
	 ("interiorleft" . ("InteriorLeft" "VX-Rexx property" nil t))
	 ("interiortop" . ("InteriorTop" "VX-Rexx property" nil t))
	 ("interiorwidth" . ("InteriorWidth" "VX-Rexx property" nil t))
	 ("invokehelp" . ("InvokeHelp" "VX-Rexx method" nil t))
	 ("itemborder" . ("ItemBorder" "VX-Rexx property" nil t))
	 ("itemheight" . ("ItemHeight" "VX-Rexx property" nil t))
	 ("itemtype" . ("ItemType" "VX-Rexx property" nil t))
	 ("itemwidth" . ("ItemWidth" "VX-Rexx property" nil t))
	 ("justification" . (nil "VX-Rexx property" nil t))
	 ("keystring" . ("KeyString" "VX-Rexx property" nil t))
	 ("lastrecord" . ("LastRecord" "VX-Rexx property" nil t))
	 ("lastsplitfield" . ("LastSplitField" "VX-Rexx property" nil t))
	 ("layoutstyle" . ("LayoutStyle" "VX-Rexx property" nil t))
	 ("left" . (nil "VX-Rexx property" nil t))
	 ("listchildren" . ("ListChildren" "VX-Rexx method" nil t))
	 ("listclasses" . ("ListClasses" "VX-Rexx method" nil t))
	 ("listmethods" . ("ListMethods" "VX-Rexx method" nil t))
	 ("listprinters" . ("ListPrinters" "VX-Rexx method" nil t))
	 ("listproperties" . ("ListProperties" "VX-Rexx method" nil t))
	 ("listthreads" . ("ListThreads" "VX-Rexx method" nil t))
	 ("listvars" . ("ListVars" "VX-Rexx method" nil t))
	 ("listwindows" . ("ListWindows" "VX-Rexx method" nil t))
	 ("loadclassfile" . ("LoadClassFile" "VX-Rexx method" nil t))
	 ("majortabpos" . ("MajorTabPos" "VX-Rexx property" nil t))
	 ("margin" . (nil "VX-Rexx property" nil t))
	 ("masked" . (nil "VX-Rexx property" nil t))
	 ("maximize" . (nil "VX-Rexx method" nil t))
	 ("maximizebutton" . ("MaximizeButton" "VX-Rexx property" nil t))
	 ("miniicons" . ("MiniIcons" "VX-Rexx property" nil t))
	 ("minimize" . (nil "VX-Rexx method" nil t))
	 ("minimizebutton" . ("MinimizeButton" "VX-Rexx property" nil t))
	 ("movewithparent" . ("MoveWithParent" "VX-Rexx property" nil t))
	 ("multiselect" . ("MultiSelect" "VX-Rexx property" nil t))
	 ("name" . (nil "VX-Rexx property" nil t))
	 ("numericonly" . ("NumericOnly" "VX-Rexx property" nil t))
	 ("orientation" . (nil "VX-Rexx property" nil t))
	 ("padwithzeros" . ("PadWithZeros" "VX-Rexx property" nil t))
	 ("pagecount" . ("PageCount" "VX-Rexx property" nil t))
	 ("painting" . (nil "VX-Rexx property" nil t))
	 ("parent" . (nil "VX-Rexx property" nil t))
	 ("paste" . (nil "VX-Rexx method" nil t))
	 ("percentile" . (nil "VX-Rexx property" nil t))
	 ("picturepath" . ("PicturePath" "VX-Rexx property" nil t))
	 ("pointer" . (nil "VX-Rexx property" nil t))
	 ("poke" . (nil "VX-Rexx method" nil t))
	 ("popup" . (nil "VX-Rexx method" nil t))
	 ("post" . (nil "VX-Rexx method" nil t))
	 ("postkeystring" . ("PostKeyString" "VX-Rexx method" nil t))
	 ("postqueue" . ("PostQueue" "VX-Rexx method" nil t))
	 ("preloadpages" . ("PreloadPages" "VX-Rexx property" nil t))
	 ("program" . (nil "VX-Rexx property" nil t))
	 ("putclipboard" . ("PutClipboard" "VX-Rexx method" nil t))
	 ("putvar" . ("PutVar" "VX-Rexx method" nil t))
	 ("readonly" . ("ReadOnly" "VX-Rexx property" nil t))
	 ("removerecord" . ("RemoveRecord" "VX-Rexx method" nil t))
	 ("request" . (nil "VX-Rexx method" nil t))
	 ("requestlist" . ("RequestList" "VX-Rexx method" nil t))
	 ("reset" . (nil "VX-Rexx method" nil t))
	 ("resizepicture" . ("ResizePicture" "VX-Rexx property" nil t))
	 ("restore" . (nil "VX-Rexx method" nil t))
	 ("ribboncolor" . ("RibbonColor" "VX-Rexx property" nil t))
	 ("ribbonstrip" . ("RibbonStrip" "VX-Rexx property" nil t))
	 ("rows" . (nil "VX-Rexx property" nil t))
	 ("selected" . (nil "VX-Rexx property" nil t))
	 ("selectedend" . ("SelectedEnd" "VX-Rexx property" nil t))
	 ("selectedstart" . ("SelectedStart" "VX-Rexx property" nil t))
	 ("selectedstring" . ("SelectedString" "VX-Rexx property" nil t))
	 ("selectedtext" . ("SelectedText" "VX-Rexx property" nil t))
	 ("self" . (nil "VX-Rexx property" nil t))
	 ("sendkeystring" . ("SendKeyString" "VX-Rexx method" nil t))
	 ("server" . (nil "VX-Rexx property" nil t))
	 ("serverhwnd" . ("ServerHWnd" "VX-Rexx property" nil t))
	 ("set" . (nil "VX-Rexx property" nil t))
	 ("setattributes" . ("SetAttributes" "VX-Rexx method" nil t))
	 ("setfieldattr" . ("SetFieldAttr" "VX-Rexx method" nil t))
	 ("setfielddata" . ("SetFieldData" "VX-Rexx method" nil t))
	 ("setfocus" . ("SetFocus" "VX-Rexx method" nil t))
	 ("setitemdata" . ("SetItemData" "VX-Rexx method" nil t))
	 ("setitemdatalist" . ("SetItemDataList" "VX-Rexx method" nil t))
	 ("setpagewindow" . ("SetPageWindow" "VX-Rexx method" nil t))
	 ("setrecordattr" . ("SetRecordAttr" "VX-Rexx method" nil t))
	 ("setselectedlist" . ("SetSelectedList" "VX-Rexx method" nil t))
	 ("setstatustext" . ("SetStatusText" "VX-Rexx method" nil t))
	 ("setstringlist" . ("SetStringList" "VX-Rexx method" nil t))
	 ("settabtext" . ("SetTabText" "VX-Rexx method" nil t))
	 ("setticklabels" . ("SetTickLabels" "VX-Rexx method" nil t))
	 ("setticksizes" . ("SetTickSizes" "VX-Rexx method" nil t))
	 ("showcaption" . ("ShowCaption" "VX-Rexx property" nil t))
	 ("showhints" . ("ShowHints" "VX-Rexx property" nil t))
	 ("showtitles" . ("ShowTitles" "VX-Rexx property" nil t))
	 ("showtreeline" . ("ShowTreeLine" "VX-Rexx property" nil t))
	 ("shutdown" . ("ShutDown" "VX-Rexx property" nil t))
	 ("sibling" . (nil "VX-Rexx property" nil t))
	 ("siblingorder" . ("SiblingOrder" "VX-Rexx property" nil t))
	 ("sliderbuttons" . ("SliderButtons" "VX-Rexx property" nil t))
	 ("snaptotick" . ("SnapToTick" "VX-Rexx property" nil t))
	 ("sort" . (nil "VX-Rexx property" nil t))
	 ("sortrecords" . ("SortRecords" "VX-Rexx method" nil t))
	 ("source" . (nil "VX-Rexx property" nil t))
	 ("splitbarleft" . ("SplitBarLeft" "VX-Rexx property" nil t))
	 ("startdrag" . ("StartDrag" "VX-Rexx method" nil t))
	 ("startthread" . ("StartThread" "VX-Rexx method" nil t))
	 ("status" . (nil "VX-Rexx property" nil t))
	 ("statusarea" . ("StatusArea" "VX-Rexx property" nil t))
	 ("statustext" . ("StatusText" "VX-Rexx property" nil t))
	 ("statustextalignment" . ("StatusTextAlignment" "VX-Rexx property" nil t))
	 ("supportsmethod" . ("SupportsMethod" "VX-Rexx method" nil t))
	 ("supportsproperty" . ("SupportsProperty" "VX-Rexx method" nil t))
	 ("systemmenu" . ("SystemMenu" "VX-Rexx property" nil t))
	 ("tabgroup" . ("TabGroup" "VX-Rexx property" nil t))
	 ("tabindex" . ("TabIndex" "VX-Rexx property" nil t))
	 ("tabshape" . ("TabShape" "VX-Rexx property" nil t))
	 ("tabstop" . ("TabStop" "VX-Rexx property" nil t))
	 ("tabtextalignment" . ("TabTextAlignment" "VX-Rexx property" nil t))
	 ("terminate" . (nil "VX-Rexx method" nil t))
	 ("textlimit" . ("TextLimit" "VX-Rexx property" nil t))
	 ("tickindex" . ("TickIndex" "VX-Rexx property" nil t))
	 ("ticklist" . ("TickList" "VX-Rexx property" nil t))
	 ("tickposition" . ("TickPosition" "VX-Rexx property" nil t))
	 ("ticks" . (nil "VX-Rexx property" nil t))
	 ("ticksize" . ("TickSize" "VX-Rexx property" nil t))
	 ("titlebar" . ("TitleBar" "VX-Rexx property" nil t))
	 ("top" . (nil "VX-Rexx property" nil t))
	 ("topic" . (nil "VX-Rexx property" nil t))
	 ("treeindent" . ("TreeIndent" "VX-Rexx property" nil t))
	 ("treeline" . ("TreeLine" "VX-Rexx property" nil t))
	 ("undo" . (nil "VX-Rexx method" nil t))
	 ("userdata" . ("UserData" "VX-Rexx property" nil t))
	 ("validaterecord" . ("ValidateRecord" "VX-Rexx method" nil t))
	 ("value" . (nil "VX-Rexx property" nil t))
	 ("vertjustification" . ("VertJustification" "VX-Rexx property" nil t))
	 ("vertscroll" . ("VertScroll" "VX-Rexx property" nil t))
	 ("view" . (nil "VX-Rexx property" nil t))
	 ("visible" . (nil "VX-Rexx property" nil t))
	 ("vrchattr" . ("VRChAttr" "VX-Rexx" "ok=VRChAttr(file-spec,[set-on],[set-off])"))
	 ("vrchdir" . ("VRChDir" "VX-Rexx"))
	 ("vrchdrive" . ("VRChDrive" "VX-Rexx"))
	 ("vrcopyfile" . ("VRCopyFile" "VX-Rexx"))
	 ("vrcreate" . ("VRCreate" "VX-Rexx"))
	 ("vrcreatefile" . ("VRCreateFile" "VX-Rexx"))
	 ("vrcreatestem" . ("VRCreateStem" "VX-Rexx"))
	 ("vrcurrdir" . ("VRCurrDir" "VX-Rexx"))
	 ("vrcurrdrive" . ("VRCurrDrive" "VX-Rexx"))
	 ("vrdeletefile" . ("VRDeleteFile" "VX-Rexx"))
	 ("vrdelini" . ("VRDelIni" "VX-Rexx"))
	 ("vrdestroy" . ("VRDestroy" "VX-Rexx"))
	 ("vrdir" . ("VRDir" "VX-Rexx"))
	 ("vrdiskinfo" . ("VRDiskInfo" "VX-Rexx"))
	 ("vrdisklabel" . ("VRDiskLabel" "VX-Rexx"))
	 ("vrerror" . ("VRError" "VX-Rexx"))
	 ("vrevent" . ("VREvent" "VX-Rexx"))
	 ("vrxpandfilename" . ("VRExpandFileName" "VX-Rexx"))
	 ("vrfiledate" . ("VRFileDate" "VX-Rexx"))
	 ("vrfiledialog" . ("VRFileDialog" "VX-Rexx"))
	 ("vrfileexists" . ("VRFileExists" "VX-Rexx"))
	 ("vrfindfile" . ("VRFindFile" "VX-Rexx"))
	 ("vrfini" . ("VRFini" "VX-Rexx"))
	 ("vrget" . ("VRGet" "VX-Rexx"))
	 ("vrgetfiletype" . ("VRGetFileType" "VX-Rexx"))
	 ("vrgetini" . ("VRGetIni" "VX-Rexx"))
	 ("vrinfo" . ("VRInfo" "VX-Rexx"))
	 ("vrinidir" . ("VRIniDir" "VX-Rexx"))
	 ("vrinit" . ("VRInit" "VX-Rexx"))
	 ("vrisdir" . ("VRIsDir" "VX-Rexx"))
	 ("vrisvalidobject" . ("VRIsValidObject" "VX-Rexx"))
	 ("vrlistfiletypes" . ("VRListFileTypes" "VX-Rexx"))
	 ("vrload" . ("VRLoad" "VX-Rexx"))
	 ("vrloadsecondary" . ("VRLoadSecondary" "VX-Rexx"))
	 ("vrmessage" . ("VRMessage" "VX-Rexx"))
	 ("vrmessagestem" . ("VRMessageStem" "VX-Rexx"))
	 ("vrmethod" . ("VRMethod" "VX-Rexx"))
	 ("vrmkdir" . ("VRMkDir" "VX-Rexx"))
	 ("vroptions" . ("VROptions" "VX-Rexx"))
	 ("vrparsefilename" . ("VRParseFileName" "VX-Rexx"))
	 ("vrparsefilepath" . ("VRParseFilePath" "VX-Rexx"))
	 ("vrprintfile" . ("VRPrintFile" "VX-Rexx"))
	 ("vrprintjobdialog" . ("VRPrintJobDialog" "VX-Rexx"))
	 ("vrprompt" . ("VRPrompt" "VX-Rexx"))
	 ("vrredirectstdio" . ("VRRedirectStdIO" "VX-Rexx"))
	 ("vrrenamefile" . ("VRRenameFile" "VX-Rexx"))
	 ("vrrmdir" . ("VRRmDir" "VX-Rexx"))
	 ("vrset" . ("VRSet" "VX-Rexx"))
	 ("vrsetfiletype" . ("VRSetFileType" "VX-Rexx"))
	 ("vrsetini" . ("VRSetIni" "VX-Rexx"))
	 ("vrsortstem" . ("VRSortStem" "VX-Rexx"))
	 ("vrversion" . ("VRVersion" "VX-Rexx"))
	 ("vrwindow" . ("VRWindow" "VX-Rexx"))
	 ("vrwindowpath" . ("VRWindowPath" "VX-Rexx"))
	 ("width" . (nil "VX-Rexx property" nil t))
	 ("windowmode" . ("WindowMode" "VX-Rexx property" nil t))
	 ("windowstate" . ("WindowState" "VX-Rexx property" nil t))
	 ("wordbreak" . ("WordBreak" "VX-Rexx property" nil t))
	 ("wordwrap" . ("WordWrap" "VX-Rexx property" nil t))
	 ("workingdirectory" . ("WorkingDirectory" "VX-Rexx property" nil t)))
       rexx-external-function-table))
