;;; rexx-os2.el --- REXX completion for use with rexx-mode.el
;; Copyright (C) 1994 Free Software Foundation, Inc.

;; Maintainer: Scott Maxwell - scottmax@netcom.com
;; Keywords: rexx
;;
;; This is the small version of the completion file.  If you want
;; full documentation, you should use rexx-os2.el.  (That is the default.)

(setq rexx-command-table
      '(
	("abbrev" . (nil "function"))
	("abs" . (nil "function"))
	("address" . (nil "command and function"))
	("arg" . (nil "command and function"))
	("b2x" . (nil "function"))
	("beep" . (nil "function"))
	("bitand" . ("BitAnd" "function"))
	("bitor" . ("BitOr" "function"))
	("bitxor" . ("BitXor" "function"))
	("c2d" . ("C2D" "function"))
	("c2x" . ("C2X" "function"))
	("call" . (nil "command"))
	("center" . (nil "function"))
	("centre" . (nil "function"))
	("charin" . ("CharIn" "function"))
	("charout" . ("CharOut" "function"))
	("chars" . (nil "function"))
	("compare" . (nil "function"))
	("condition" . (nil "function"))
	("copies" . (nil "function"))
	("d2c" . ("D2C" "function"))
	("d2x" . ("D2X" "function"))
	("datatype" . ("DataType" "function"))
	("date" . (nil "function"))
	("delstr" . ("DelStr" "function"))
	("delword" . ("DelWord" "function"))
	("digits" . (nil "function"))
	("directory" . (nil "function"))
	("do" . (nil "command"))
	("drop" . (nil "command"))
	("else" . (nil "command"))
	("errortext" . ("ErrorText" "function"))
	("endlocal" . ("EndLocal" "function"))
	("end" . (nil "command"))
	("exit" . (nil "command"))
	("filespec" . ("FileSpec" "function"))
	("form" . (nil "function"))
	("format" . (nil "function"))
	("fuzz" . (nil "function"))
	("if" . (nil "command"))
	("insert" . (nil "function"))
	("interpret" . (nil "command"))
	("iterate" . (nil "command"))
	("lastpos" . ("LastPos" "function"))
	("leave" . (nil "command"))
	("left" . (nil "function"))
	("length" . (nil "function"))
	("linein" . ("LineIn" "function"))
	("lineout" . ("LineOut" "function"))
	("lines" . (nil "function"))
	("max" . (nil "function"))
	("min" . (nil "function"))
	("nop" . (nil "command"))
	("numeric" . (nil "command"))
	("options" . (nil "command"))
	("overlay" . (nil "function"))
	("parse" . (nil "command"))
	("pos" . (nil "function"))
	("procedure" . (nil "command"))
	("pull" . (nil "command"))
	("push" . (nil "command"))
	("queue" . (nil "command"))
	("queued" . (nil "function"))
	("random" . (nil "function"))
	("return" . (nil "command"))
	("reverse" . (nil "function"))
	("right" . (nil "function"))
	("rxfuncadd" . ("RxFuncAdd" "function"))
	("rxfuncdrop" . ("RxFuncDrop" "function"))
	("rxfuncquery" . ("RxFuncQuery" "function"))
	("say" . (nil "command"))
	("select" . (nil "command"))
	("setlocal" . ("SetLocal" "function"))
	("sign" . (nil "function"))
	("signal" . (nil "command"))
	("sourceline" . ("SourceLine" "function"))
	("space" . (nil "function"))
	("stream" . (nil "function"))
	("strip" . (nil "function"))
	("substr" . ("SubStr" "function"))
	("subword" . ("SubWord" "function"))
	("symbol" . (nil "function"))
	("then" . (nil "command"))
	("time" . (nil "function"))
	("trace" . (nil "command and function"))
	("translate" . (nil "function"))
	("trunc" . (nil "function"))
	("value" . (nil "function"))
	("verify" . (nil "function"))
	("word" . (nil "function"))
	("wordindex" . ("WordIndex" "function"))
	("wordlength" . ("WordLength" "function"))
	("wordpos" . ("WordPos" "function"))
	("words" . (nil "function"))
	("x2b" . ("X2B" "function"))
	("x2c" . ("X2C" "function"))
	("x2d" . ("X2D" "function"))
	("xrange" . ("XRange" "function"))))



(setq rexx-external-function-table
      '(
	("rxmessagebox" . ("RxMessageBox" "RexxUtil"))
	("syscls" . ("SysCls" "RexxUtil"))
	("syscreateobject" . ("SysCreateObject" "RexxUtil"))
	("syscurpos" . ("SysCurPos" "RexxUtil"))
	("syscurstate" . ("SysCurState" "RexxUtil"))
	("sysderegisterclass" . ("SysDeregisterClass" "RexxUtil"))
	("sysdestroyobject" . ("SysDestroyObject" "RexxUtil"))
	("sysdriveinfo" . ("SysDriveInfo" "RexxUtil"))
	("sysdrivemap" . ("SysDriveMap" "RexxUtil"))
	("sysdropfuncs" . ("SysDropFuncs" "RexxUtil"))
	("sysfiledelete" . ("SysFileDelete" "RexxUtil"))
	("sysfiletree" . ("SysFileTree" "RexxUtil"))
	("sysfilesearch" . ("SysFileSearch" "RexxUtil"))
	("sysgetea" . ("SysGetEA" "RexxUtil"))
	("sysgetkey" . ("SysGetKey" "RexxUtil"))
	("sysgetmessage" . ("SysGetMessage" "RexxUtil"))
	("sysini" . ("SysIni" "RexxUtil"))
	("sysmkdir" . ("SysMkDir" "RexxUtil"))
	("sysos2ver" . ("SysOS2Ver" "RexxUtil"))
	("sysputea" . ("SysPutEA" "RexxUtil"))
	("sysqueryclasslist" . ("SysQueryClassList" "RexxUtil"))
	("sysregisterobjectclass" . ("SysRegisterObjectClass" "RexxUtil"))
	("sysrmdir" . ("SysRmDir" "RexxUtil"))
	("syssearchpath" . ("SysSearchPath" "RexxUtil"))
	("sysseticon" . ("SysSetIcon" "RexxUtil"))
	("syssetobjectdata" . ("SysSetObjectData" "RexxUtil"))
	("syssleep" . ("SysSleep" "RexxUtil"))
	("systempfilename" . ("SysTempFileName" "RexxUtil"))
	("systextscreenread" . ("SysTextScreenRead" "RexxUtil"))
	("systextscreensize" . ("SysTextScreenSize" "RexxUtil"))
	("syswaitnamedpipe" . ("SysWaitNamedPipe" "RexxUtil"))))
