;;; rexx-os2.el --- REXX completion and documentation for OS/2 external
;;;		    functions for use with rexx-mode.el
;; Copyright (C) 1994 Scott Maxwell

;; Maintainer: Scott Maxwell - scottmax@netcom.com
;; Keywords: rexx

;; To add REXX external commands to your completion and documentation table,
;; add the following line to your .emacs:
;;	(setq rexx-additional-doc-files '("rexx-os2"))
;;
;; If you already define rexx-additional-doc-files, you can make a list
;; of packages like this:
;;	(setq rexx-additional-doc-files '("rexx-os2"
;;					  "rexxbase-doc"
;;					  "vxrexx-doc"))
;; You may have to reload Emacs for your changes to take affect.


(setq rexx-external-function-table
      (append
       '(
	 ("rxfuncadd" . ("RxFuncAdd" "OS/2 REXX function"
			 "r=RxFuncAdd(name,module,procedure)\n
RXFuncAdd registers external functions, making them available
to all REXX sessions.  A return value of 0 indicates success.
Generally, name and procedure are both the name of the function
and module is the name of the DLL or external library file.

Example: Call RxFuncAdd(\"SysFileDelete\",\"RexxUtil\",\"SysFileDelete\"))"
			 nil 'rexx-rxfuncadd))
	 ("rxfuncdrop" . ("RxFuncDrop" "OS/2 REXX function" "r=RxFuncDrop(name)"))
	 ("rxfuncquery" . ("RxFuncQuery" "OS/2 REXX function" "r=RxFuncQuery(name)\n
Returns 0 if function is registered, 1 if not."))
	 ("rxmessagebox" . ("RxMessageBox" "RexxUtil" "
r=RxMessageBox(text, [title],[button],[icon])

Creates a message box.  The button defaults to OK and can be:
	OK OKCANCEL CANCEL ENTER ENTERCANCEL RETRYCANCEL
	ABORTRETRYIGNORE YESNO YESNOCANCEL
The icon can be:
	NONE HAND QUESTION EXCLAMATION ASTERISK
	INFORMATION QUERY WARNING ERROR
This cannot be used in a REXX program running in a commandline window."))
	 ("syscls" . ("SysCls" "RexxUtil" "CALL SysCls\n
Clears the screen."))
	 ("syscreateobject" . ("SysCreateObject" "RexxUtil" "
r=SysCreateObject(classname, title, location, [setup], [option]

Returns 1 if successful, 0 if not."))
	 ("syscurpos" . ("SysCurPos" "RexxUtil" "pos=SysCurPos([row],[col])\n
Move the cursor to row,col if specified.
Return current position as 'row col'."))
	 ("syscurstate" . ("SysCurState" "RexxUtil" "CALL SysCurState state\n
Turn curson 'ON' or 'OFF'."))
	 ("sysderegisterclass" . ("SysDeregisterClass" "RexxUtil" "
r=SysDeregisterClass(classname)

Returns 1 if successful, 0 if not."))
	 ("sysdestroyobject" . ("SysDestroyObject" "RexxUtil" "
r=SysDestroyObject(name)

Returns 1 if successful, 0 if not."))
	 ("sysdriveinfo" . ("SysDriveInfo" "RexxUtil" "info=SysDriveInfo(drive)

Returns 'drive: free total label"))
	 ("sysdrivemap" . ("SysDriveMap" "RexxUtil" "
map=SysDriveMap([drive],[opt])

drive specifies the drive to start from.
opt can be 'USED' 'FREE' 'LOCAL' 'REMOTE' 'DETACHED'.
Returns a list of drives, i.e. 'C: D: E:'"))
	 ("sysdropfuncs" . ("SysDropFuncs" "RexxUtil" "CALL SysDropFuncs\n
Drops all RexxUtil functions."))
	 ("sysfiledelete" . ("SysFileDelete" "RexxUtil" "rc=SysFileDelete(file)\n
Delete one file.  Return 0 if successful."))
	 ("sysfiletree" . ("SysFileTree" "RexxUtil" "
CALL SysFileTree filespec,stem,[options],[attrib],[newattrib]

Returns a list of files, one per variable in stem, setting stem.0 to filecount.
Options are:
 'F'iles only
 'D'irectories only
 'B'oth files and directories
 'S'can subdirectories
 'T'ime field format is YY/MM/DD/HH/MM
 'O'nly report full filenames
The default is to return 'date time size attributes fullpath' for each file."))
	 ("sysfilesearch" . ("SysFileSearch" "RexxUtil" "
CALL SysFileSearch string, file, stem, [options]

Search file for string, return all matched lines in stem, setting stem.0
to match count.  Option may contain 'C' to change to case sensitive and/or
'N' to include line numbers in returned strings."))
	 ("sysgetea" . ("SysGetEA" "RexxUtil" "ea=SysGetEA(file,name,variable)

Retrieves extended attribute from file.  Returns 0 if successful.
Places value in variable."))
	 ("sysgetkey" . ("SysGetKey" "RexxUtil" "key=SysGetKey([opt])\n
Gets the next key from the keyboard.
opt can be 'ECHO' (default) or 'NOECHO'."))
	 ("sysgetmessage" . ("SysGetMessage" "RexxUtil" "
msg=SysGetMessage(num,[file],[str1],...[str0])

Returns the message associated with num."))
	 ("sysini" . ("SysIni" "RexxUtil"))
	 ("sysmkdir" . ("SysMkDir" "RexxUtil" "rc=SysMkDir(name)\n
Create directory.  Returns 0 if successful."))
	 ("sysos2ver" . ("SysOS2Ver" "RexxUtil" "ver=SysOS2Ver()\n
Version in form 'x.xx'"))
	 ("sysputea" . ("SysPutEA" "RexxUtil" "ea=SysPutEA(file,name,value)\n
Writes value to extended attribute called name in file.
Returns 0 if successful."))
	 ("sysqueryclasslist" . ("SysQueryClassList" "RexxUtil" "
CALL SysQueryClassList stem

Returns a list of all WPS classes in stem, setting stem.0 to count."))
	 ("sysregisterobjectclass" . ("SysRegisterObjectClass" "RexxUtil" "
r=SysRegisterObjectClass(classname,module)

Register a new WPS class contained in module.DLL.
Returns 1 if successful."))
	 ("sysrmdir" . ("SysRmDir" "RexxUtil" "rc=SysRmDir(name)\n
Remove directory.  Returns 0 if successful."))
	 ("syssearchpath" . ("SysSearchPath" "RexxUtil" "
spath=SysSearchPath(path,filename)

path specifies an environment variable.
Return the first location of filename in the path."))
	 ("sysseticon" . ("SysSetIcon" "RexxUtil" "
r=SysSetIcon(filename,iconfilename)

Attaches icon to file.  Returns 1 if successful."))
	 ("syssetobjectdata" . ("SysSetObjectData" "RexxUtil" "
r=SysSetObjectData(name,setup)

Returns 1 if successful."))
	 ("syssleep" . ("SysSleep" "RexxUtil" "CALL SysSleep secs"))
	 ("systempfilename" . ("SysTempFileName" "RexxUtil" "
file=SysTempFileName(template,[filter])

Returns a unique filename given template.  Template is generally of
the form \"C:\OS2\??TMP.???\", having up to 5 filter characters.
Filter specifies an alternative filter character to '?'."))
	 ("systextscreenread" . ("SysTextScreenRead" "RexxUtil" "
string=SysTextScreenRead(row,col,[len])

Reads characters from the screen into string.  If len is not specified,
reads to the end of the screen."))
	 ("systextscreensize" . ("SysTextScreenSize" "RexxUtil" "
size=SysTextScreenSize()

Returns 'row col'."))
	 ("syswaitnamedpipe" . ("SysWaitNamedPipe" "RexxUtil" "
r=SysWaitNamedPipe(name,[timeout])

timeout specifies the number of microseconds to wait.  If not
specified, waits the default time.  -1 specifies to wait until
not busy.

Returns 0 if not busy, 2 if not found, 231 if timed-out.")))
       rexx-external-function-table))

(defun rexx-rxfuncadd ()
  (let* ((funcname (rexx-complete-external "Name of function to register: "))
	 (package (or
		   (elt (assoc (downcase funcname) rexx-external-function-table) 2)
		   (read-string "Name of package: "))))
    (insert "\"" funcname "\",\"" package "\",\"" funcname "\"")))
	  