;;; rexx-doc.el --- REXX completion and documentation for use with rexx-mode.el
;; Copyright (C) 1994 Free Software Foundation, Inc.

;; Maintainer: Scott Maxwell - scottmax@netcom.com
;; Keywords: rexx


;; If you would like to make a file of additional documentation for
;; a package of external function calls, you should make a file in
;; the following format and distribute it with your package.  If you
;; have rexx-os2.el, you can use this as a template.
;;
;;(setq rexx-external-function-table
;;      (append '(
;;		  ("name1" . info)
;;		  ("name2" . info))
;;	        rexx-external-function-table))
;;
;;********************* IMPORTANT ******************************
;; The first element must be the function name in all lowercase.
;;********************* IMPORTANT ******************************
;;
;; The info element can be either nil or a list.
;; If it is a list, it can have up to five elements.  These are:
;;   1) Pretty name.  For instance "BitAnd".  If this is present
;;	rexx-mode will use it instead of capitalizing.
;;
;;   2) Type/package.  This is usually just the name of the
;;	function package i.e. "RexxUtil".  In this case, the
;;	documentation string would describe the function as:
;;	  "an external function from the RexxUtil package"
;;
;;	Alternatively, you can put a different description here.
;;	If there are any spaces in the type/package field, rexx-mode
;;	will automatically print just the field.  For instance:
;;	  ("aack" . (nil "an function for modifying Bill"))
;;	specifies a function called "aack" that uses default
;;	capitalization, and is described by rexx-function-help as:
;;	  "aack: an function for modifying Bill"
;;
;;   3) Documentation string.  This can be multiple lines.  For instance:
;;	  ("accept" . (nil "\"VX-Rexx method for DDEClient" "Syntax:
;;ok=VRMethod( object, \"Accept\", [conversation])
;;
;;Description:
;;  Establishes a conversation with a DDE server."))
;;
;;	Note that additional lines should start at the left edge and
;;	all quotes must be specified as \".
;;
;;   4) Set to t if this is not actually a function and should only
;;	follow a quote character, for instance:
;;	  ("addfield" . ("AddField" "VX-Rexx method" nil t))
;;	specifies a method called "addfield" which will be converted
;;	to the pretty name of "AddField" if rexx-function-auto-capitilize
;;	is non-nil and will only appear immediately following " or '.
;;	It will be described as:
;;	  "AddField: VX-Rexx method"
;;   5) Specifies a function to run every time this element is capitalized
;;	by hitting space or open paren at the end of a line.  This can be
;;	used for further automating complex function completion.  For more
;;	information, look at the doc for rexx-do-super-completion.  Also,
;;	look at	RxFuncAdd in rexx-os2.el for an example of how this works.
;;	Rexx-mode provides rexx-complete-external for doing mini-buffer
;;	completion on external function names.
;;	NOTE: This extra expansion will not kick in unless the user defines
;;	      rexx-super-completion-mode as t.

;;
;; You should also instruct your users to add a group of lines that
;; looks something like this to their .emacs file:
;;	(setq rexx-additional-doc-files '("rexx-os2"
					  "vxrexx-doc"
;;					  "myfuncs-doc"))
;; Then they will need to kill and reload Emacs.


(setq rexx-command-table
      '(
	("abbrev" . (nil "function" "is=Abbrev(string,abbrev,[len]\n
Returns 1 if string starts with abbrev."))
	("abs" . (nil "function" "a=Abs(number)\n
Returns the absolute value of number."))
	("address" . (nil "command and function" "Command  form: ADDRESS environment [expression]
Function form: env=Address()

The command form changes the environment.  If an expression is specified,
the environment automatically reverts back after the expression is evaluated.
Otherwise, the environment is changed until the next ADDRESS command is
encountered.

The function form simply returns the name of the current environment."))
	("arg" . (nil "command and function" "Command  form: ARG template
Function form: a=Arg([n],[option])

The command form is shorthand for PARSE UPPER ARG and is used to parse
command-line or procedure parameters.

The function for returns the nth parameter passed to the procedure or
program.  If the 'E'xists or 'O'mitted option is specified, the function
returns 1 if the condition is true for the nth parameter.
If neither n nor option is specified, Arg returns the number of parameters.
Note: The first parameter is 1."))
	("b2x" . (nil "function" "x=B2X(binary_string)\n
Returns ASCII hex representation of the ASCII binary string."))
	("beep" . (nil "function" "call beep [frequency],[duration]\n
Frequency specifies Hertz and duration specifies milliseconds.
Often both parameters are omitted and the default beep is used."))
	("bitand" . ("BitAnd" "function" "ba=BitAnd(string1,string2,[pad])"))
	("bitor" . ("BitOr" "function" "bo=BitOr(string1,string2,[pad])"))
	("bitxor" . ("BitXor" "function" "bx=BitXor(string1,string2,[pad])"))
	("by" . (nil "do sub-command"))
	("c2d" . ("C2D" "function" "d=C2D(string,[n])\n
Converts a single character or pair of characters to a decimal number.
If n is not specified, an unsigned number is returned.  If n is 0,
0 is returned.  If n is not 0, a signed 16bit number is returned.

Example:
  C2D('A') -> 65"))
	("c2x" . ("C2X" "function" "hx=C2X(string)\n
Returns the hexidecimal representation of a string."))
	("call" . (nil "command" "CALL name [expressions]
CALL OFF ERROR|FAILURE|HALT|NOTREADY
CALL ON ERROR|FAILURE|HALT|NOTREADY [NAME trap-name]"))
	("center" . (nil "function" "c=Center(string,length,[pad])"))
	("centre" . (nil "function" "c=Centre(string,length,[pad])"))
	("charin" . ("CharIn" "function" "c=CharIn([filename],[start],[length])\n
If filename is not specified, it defaults to STDIN.
If start is not specified, it defaults to the next character.
A value of 1 specifies the beginning of the file.
If length is not specified, it defaults to 1."))
	("charout" . ("CharOut" "function" "c=CharOut([filename],[string],[start])\n
If filename is not specified, it defaults to STDOUT.
If start is not specified, it defaults to the next character.
A value of 1 specifies the beginning of the file.
If neither string nor start is specified, the file is closed.

Returns the number of characters written."))
	("chars" . (nil "function" "c=Chars([filename])\n
Returns the number of characters remaining to be read in the stream
or STDIN if no filename is specified."))
	("compare" . (nil "function" "c=Compare(string1,string2,[pad])\n
Returns 0 if both strings are identical otherwise returns the character
number where they first differ.  Pad defaults to space and is used to
extend the shorter string."))
	("condition" . (nil "function" "c=Condition([option])\n
Returns requested information about the current error trap.
Options are:  'C'ondition name
	      'D'escription (this is the default)
	      'I'nstruction
	      'S'tatus (i.e. ON or OFF)"))
	("copies" . (nil "function" "c=Copies(string,n)\n
Returns a string with n copies of string."))
	("d2c" . ("D2C" "function" "c=D2C(wholenumber,[n])\n
Returns the character representation of wholenumber. n specifies the length.
If it is greater than 1, the string will be padded with spaces on the left."))
	("d2x" . ("D2X" "function" "x=D2X(wholenumber,[n])\n
Returns the hexidecimal representation of wholenumber.
n specifies the length, padding the string with zeros."))
	("datatype" . ("DataType" "function" "d=DataType(string,[type])\n
If type is not specified, DataType returns either NUM or CHAR.
Otherwise, DataType returns 1 if the string is of the specified type.
Valid types are:
  'A'lphanumeric	(A-Z, a-z, 0-9
  'B'its		(0 or 1)
  'C'			(mixed SBCS/DBCS string)
  'D'bcs		(pure DBCS string)
  'L'owercase
  'M'ixed case
  'N'umber
  'S'ymbol		(character valid in REXX symbols including A-Z, a-z)
  'U'ppercase
  'W'hole number
  he'X'adecimal		(0-9, A-F, a-f, space)"))
	("date" . (nil "function" "d=Date([option])\n
With no option, return dd mon yyyy (i.e. 12 Jul 1994).
Options include:
  'B'asedate	Number of days since January 1, 0001
  'D'ays	Number of days so far this year.
  'E'uropean	dd/mm/yy
  'L'anguage	Returns dd Month yyyy in the local language format
  'M'onth	Full English name for month
  'N'ormal	As default
  'O'rdered	yy/mm/dd (good for sorting)
  'S'orted	yyyymmdd (maybe even better for sorting)
  'W'eekday	Full English name for the day of the Week"))
	("delstr" . ("DelStr" "function" "d=DelStr(string,n,[length])"))
	("delword" . ("DelWord" "function" "d=DelWord(string,n,[length])"))
	("digits" . (nil "function" "d=Digits()\n
Returns current setting of NUMERIC DIGITS."))
	("directory" . (nil "function" "d=Directory([name])\n
If name is not specified, returns current directory.
If specified, changes to name, returning name or success, null or failure.
NOTE: Name cannot end with '\' unless it is the root directory."))
	("do" . (nil "command" "Start a DO construct."))
	("drop" . (nil "command" "DROP var1 [var2] [var3]\n
Uninitializes variables."))
	("else" . (nil "command" "Used in IF/ELSE construct."))
	("end" . (nil "command" "End a DO or SELECT block."))
	("endlocal" . ("EndLocal" "function" "Call EndLocal\n
Resets drive, directory and environment saved in last SetLocal."))
	("errortext" . ("ErrorText" "function" "e=ErrorText(n)\n
Returns error message associated with n (0-99)."))
	("exit" . (nil "command" "EXIT [expression]\n
Leaves program returning expression."))
        ("expose" . (nil "procedure sub-command" "label: PROCEDURE EXPOSE varlist\n
Used to allow variables to remain visible inside a procedure.
Varlist can be any number of space delimited variable names.
If a variable name is enclosed in parenthesis, all variables listed
in the text of that variable are also exposed."))
	("filespec" . ("FileSpec" "function" "f=FileSpec(option,filespec)\n
Option can be:
  'D'rive	Drive letter with ':'
  'P'ath	Path with trailing '\'
  'N'ame	Name part of the filespec"))
	("for" . (nil "do sub-command"))
	("forever" . (nil "do sub-command"))
	("form" . (nil "function" "f=Form()"))
	("format" . (nil "function" "f=Format(number,[before],[after],[expp],[expt])"))
	("fuzz" . (nil "function" "f=Fuzz()"))
	("if" . (nil "command"))
	("insert" . (nil "function" "f=Insert(new,target,[n],[length],[pad])\n
Inserts new string into target at n or beginning."))
	("interpret" . (nil "command" "INTERPRET expression"))
	("iterate" . (nil "command" "ITERATE\n
Go back to top of DO loop.  Like 'continue' in C."))
	("lastpos" . ("LastPos" "function" "l=LastPos(search,string,[start])"))
	("leave" . (nil "command" "LEAVE\n
Breaks out of DO loop.  Like 'break' in C."))
	("left" . (nil "function" "l=Left(string,length,[pad])"))
	("length" . (nil "function" "l=Length(string)"))
	("linein" . ("LineIn" "function" "l=LineIn([filename],[line],[count])\n
Reads count lines from filename.  If filename is not specified, STDIN is used.
In OS/2, the only legal value for line if specified is 1, start of file.
Legal values for count are 0 and 1."))
	("lineout" . ("LineOut" "function" "l=LineOut([filename],[string],[line])\n
Write string to filename, returning 0 if successful, 1 if not.
If filename is not specified, STDOUT is used.
If line is specified, it must be 1 in OS/2, start of file."))
	("lines" . (nil "function" "l=Lines([filename])\n
Returns lines remaining to be read from filename.
If filename is not specified STDOUT is assumed."))
	("max" . (nil "function" "m=Max(num,[num2],[num3],..)"))
	("min" . (nil "function" "m=Min(num,[num2],[num3],..)"))
	("nop" . (nil "command" "Does nothing.  Most often used after OTHERWISE, THEN and ELSE."))
	("numeric" . (nil "command"))
	("off" . (nil "call/signal sub-command"))
	("on" . (nil "call/signal sub-command"))
	("options" . (nil "command"))
	("otherwise" . (nil "command" "Used with SELECT."))
	("overlay" . (nil "function" "o=Overlay(new,target,[n],[length],[pad])"))
	("parse" . (nil "command" "
PARSE [UPPER]	ARG	template	parses program/function parameters
		PULL	template	parses input from queue or STDIN
		SOURCE	template	get system info (OS/2 4OS2 C:\TEST.CMD)
		VALUE expression WITH template
		VAR name template	parse variable contents
		VERSION template	REXX version info
		LINEIN	template	parse next line from STDIN"))
	("pos" . (nil "function" "l=LastPos(search,string,[start])"))
	("procedure" . (nil "command" "label: PROCEDURE\n
Starts a new procedure.  Any variable not exposed becomes local and
undefined.  See EXPOSE."))
	("pull" . (nil "command" "PULL template\n
Short form for PARSE UPPER PULL."))
	("push" . (nil "command" "PUSH expression\n
Pushes the results of the expression onto the head of the active QUEUE."))
	("queue" . (nil "command" "QUEUE expression\n
Pushes the results of the expression onto the tail of the active QUEUE.")) 
	("queued" . (nil "function" "q=Queued()\n
Count of lines remaining on the active queue."))
	("random" . (nil "function" "
r=Random()			return random number between 0 and 999
r=Random(max)			return random number between 0 and max
r=Random([min],[max],[seed])	return random number between min and max"))
	("return" . (nil "command" "RETURN [expression]\n
Return from program or procedure with expression."))
	("reverse" . (nil "function" "r=Reverse(string)"))
	("right" . (nil "function" "r=Right(string,length,[pad])"))
	("rxqueue" . ("RxQueue" "function" "newq=RxQueue(command,[queuename])\n
Command can be:
 \"Create\"	Creates queue with specified or default name.  Returns name.
 \"Delete\"	Deletes named queue.  Returns 0 if successful.
 \"Get\"		Returns the name of the current queue.
 \"Set\"		Sets the name of the current queue and returns previous."))
	("say" . (nil "command" "SAY [expression]"))
	("select" . (nil "command" "
SELECT
 WHEN expression THEN
   expression
 WHEN expression THEN
   expression
 OTHERWISE
   NOP
END"))
	("setlocal" . ("SetLocal" "function" "CALL SetLocal\n
Saves current drive, directory and environment until next GetLocal."))
	("sign" . (nil "function" "s=Sign(number)\n
Returns -1, 0, or 1 depending on sign of number."))
	("signal" . (nil "command" "SIGNAL labelname
SIGNAL OFF ERROR|FAILURE|HALT|NOTREADY
SIGNAL ON ERROR|FAILURE|HALT|NOTREADY [NAME trap-name]\n
Signal does a hard goto.  It also aborts all DO, IF, INTERPRET and SELECT
statements.  It should NOT generally be used like goto in other languages."))
	("source" . (nil "parse sub-command"))
	("sourceline" . ("SourceLine" "function" "s=SourceLine([n])\n
If n is not specified, returns total number of lines in source file.
Otherwise returns nth line of sourcefile."))
	("space" . (nil "function" "s=Space(string,[n],[pad])\n
Replaces blanks between words with n pad characters.  Defaults to 1 space."))
	("stream" . (nil "function" "s=Stream(name,[option],[command])\n
Returns state of string or result of command.  Options are:
  'C'ommand	  Commands include:
			'OPEN'
			'CLOSE'
			'SEEK' offset	 Offset can be:
						=num	from start (default)
						<num	from end
						+num	forward from current
						-num	backward from current
			'QUERY EXISTS'	 Returns pathname if exists
			'QUERY SIZE'	 Returns size in bytes
			'QUERY DATETIME' Returns date and time stamps
  'D'escription	  Extended stream state info
  'S'tate	  Basic stream state info.  This is the default."))
	("strip" . (nil "function" "s=Strip(string,[option],[char])\n
Strips spaces or char from string.  Options are:
  'B'oth	Leading and trailing.  This is the default.
  'L'eading
  'T'railing"))
	("substr" . ("SubStr" "function" "s=SubStr(string,n,[length],[pad])\n
Returns substring of string starting at n."))
	("subword" . ("SubWord" "function" "s=SubWord(string,n,[length])"))
	("symbol" . (nil "function" "s=Symbol(name)\n
Returns state of symbol name.  Return values are VAR, LIT and BAD."))
	("then" . (nil "command" "Used with IF and WHEN."))
	("time" . (nil "function" "t=Time([option])\n
Returns 24-hour time by default, i.e. 16:31:50.  Options are:
 'C'ivil	hh:mmxx where xx is either am or pm
 'E'lapsed	sssssssss.uu0000  Number of seconds and tenths since 'R'eset
 'H'ours	hh
 'L'ong		hh:mm:ss.uu0000
 'M'inutes	mmmm  Minutes since midnight
 'N'ormal	as default
 'R'eset	like 'E'lapsed but also resets."))
	("to" . (nil "do sub-command"))
	("trace" . (nil "command and function"))
	("translate" . (nil "function" "t=Translate(string,[outtab],[intab],[pad])\n
If outtab and intab are unspecified, returns uppercase of string.
If specified, translates all intab characters to corresponding
outtab characters."))
	("trunc" . (nil "function" "t=Trunc(number,[n])\n
Returns number with 0 or n digits after decimal."))
	("until". (nil "do sub-command"))
	("upper" . (nil "parse sub-command"))
	("value" . (nil "function and parse/signal/trace sub-command" "v=Value(expression,[newval],[selector])\n
Returns value of variable in expression, i.e. v=Value('aack') would
return the value of aack.  If newval is specified, the variable is set
to newval.  If selector is specified in OS/2, it must be 'OS2ENVIRONMENT'.
This allows you to manipulate environment strings instead of REXX strings."))
	("var" . (nil "parse sub-command"))
	("verify" . (nil "function" "v=Verify(string,reference,[option],[start])\n
Option may be 'M'atch or 'N'omatch, nomatch being the default.
If it is nomatch, the position of the first character in string not contained
in reference is returned or 0 if all match.  If it is match, the position of
the first character in string also found in reference is returned or 0 if none."))
	("version" . (nil "parse sub-command"))
	("when" . (nil "command" "Used with SELECT."))
	("while" . (nil "do sub-command"))
	("with" . (nil "value sub-command"))
	("word" . (nil "function" "w=Word(string,n)\n
Returns nth word of string."))
	("wordindex" . ("WordIndex" "function" "w=WordIndex(string,n)\n
Returns position of start of nth word in string."))
	("wordlength" . ("WordLength" "function" "w=WordLength(string,n)\n
Returns the length of the nth word in string."))
	("wordpos" . ("WordPos" "function" "w=WordPos(phrase,string,[start])\n
Returns the word number of phrase in string."))
	("words" . (nil "function" "w=Words(string)\n
Returns number of words in string."))
	("x2b" . ("X2B" "function" "b=X2B(hexstring)\n
Returns ASCII binary representation of hexstring."))
	("x2c" . ("X2C" "function" "c=X2C(hexstring)\n
Converts hexstring to a string of characters."))
	("x2d" . ("X2D" "function" "d=X2D(hexstring)
Converts hexstring to decimal."))
	("xrange" . ("XRange" "function" "x=XRange([start],[end])\n
Returns a string containing all characters between start and end.
Start and end default to '00'x and 'FF'x respectively."))))
