/* emacscl.c
 *
 * Interface between Watcom C/C++ 10.0 IDE and GNU Emacs in Server mode
 *
 * Author:  Kai Uwe Rommel <rommel@ars.muc.de>
 * Created: Sat Aug 20 1994
 */
 
static char *rcsid =
"$Id: emacscl.c,v 1.1 1994/09/07 17:59:54 rommel Exp $";
static char *rcsrev = "$Revision: 1.1 $";

/*
 * $Log: emacscl.c,v $
 * Revision 1.1  1994/09/07 17:59:54  rommel
 * Initial revision
 * 
 */

#include <string.h>
#include <stdlib.h>

#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_WINSWITCHLIST
#include <os2.h>

#define ENTRY   __export __syscall
#define OK      TRUE
#define ERROR   FALSE

static char szEditFile[260];

static int EDITSend(char *string)
{
  PID owner_pid;
  HQUEUE hq_server;
  PVOID data;

  if (DosOpenQueue(&owner_pid, &hq_server, "/queues/emacs19/server"))
    return ERROR;

  if (DosAllocSharedMem(&data, 0, strlen(string) + 3,
			PAG_COMMIT | OBJ_GIVEABLE | PAG_READ | PAG_WRITE))
    return ERROR;

  if (DosGiveSharedMem(data, owner_pid, PAG_READ))
    return ERROR;

  strcpy(data, string);
  strcat(data, " \n");

  if (DosWriteQueue(hq_server, 0, strlen(string) + 3, data, 0))
    return ERROR;

  DosFreeMem(data);

  DosSleep(100); /* don't ask why */

  DosCloseQueue (hq_server);

  return OK;
}

int ENTRY EDITConnect(void)
{
  return OK;
}

int ENTRY EDITFile(char *szFile, char *zHelpFile)
{
  strcpy(szEditFile, szFile);

  return EDITSend(szEditFile);
}

int ENTRY EDITLocateError(long lRow, int iCol, int iLen, 
			    int idResource, char *szErrmsg)
{
  char buffer[1024];

  if (szEditFile[0] == 0)
    return ERROR;

  sprintf(buffer, "+%ld %s", lRow, szEditFile);

  return EDITSend(buffer);
}

int ENTRY EDITLocate(long lRow, int iCol, int iLen)
{
  return EDITLocateError(lRow, iCol, iLen, 0, NULL);
}

int ENTRY EDITShowWindow(int iCmdShow)
{
  return OK;
}

int ENTRY EDITDisconnect(void)
{
  return OK;
}

/* end of emacscl.c */
