#ifdef __cplusplus
   #include <stdio.h>
   extern "C" {
     extern void yyerror(char *);
     extern int yylex();
   }
#endif	/* __cplusplus */
# define TIDENT 257
# define TLBRACE 258
# define TRBRACE 259
# define TLPAREN 260
# define TRPAREN 261
# define TLBRACK 262
# define TRBRACK 263
# define TOTHER 264
# define TAUTO 265
# define TCHAR 266
# define TCLASS 267
# define TCOLON 268
# define TCOMMA 269
# define TSEMI 270
# define TDBLCOLON 271
# define TENUM 272
# define TEXTERN 273
# define TEQUAL 274
# define TFLOAT 275
# define TFRIEND 276
# define TINT 277
# define TLONG 278
# define TPUBLIC 279
# define TREG 280
# define TSHORT 281
# define TSTAR 282
# define TSTATIC 283
# define TSTRUCT 284
# define TTYPEDEF 285
# define TUNION 286
# define TUNSIGNED 287
# define TVIRTUAL 288
# define TVOID 289
# define TDEFINE 290
# define TNUM 291
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 120 "parser.y"

#include "lexer.c"
char	lastcaller[YYLMAX] = "";

clean_stack ()
{
  save_ident * i;
  while (sp > 0)
    {
      i = pop();
      free (i->name);
      free (i);
    }
}

print_stack ()
{
  save_ident * i;
  while (sp > 0)
    {
      i = pop();
      printf ("print stack: %s\n", i->name);
    }
}

record_func()
{

  char caller[YYLMAX];
  save_ident *fname;

  fname = pop();
  if ( fname == NULL ) {
    printf("%d = level, %s = lastcaller \n", level, lastcaller);
    pfnote_c("foo", 'f', 0, 0, lastcaller);
    return;
  }

  caller[0]= '\0';
  if (level)
    {
      strcpy (caller , lastcaller);
    }
  pfnote_c(fname->name, 'f', fname->line, fname->charpos, caller);
  if (!level)
    {
      /* if (strcmp (lastcaller , "") error== 0) */
      strcpy (lastcaller , fname->name);
    }
  free(fname->name);
  free (fname);
  /* clean up stack because there must have been a type */
  if (sp > 0)
    {
      fname = pop();
      free (fname->name);
      free (fname);
    }
}

record_class()
{
  save_ident *cname;
  save_ident *sname;

  if (sp >= 2)
    {
      sname = pop();
      cname = pop();
      pfnote_c(cname->name, 'c', cname->line, cname->charpos,
	       sname->name);
      free (cname->name);
      free(cname);
      free (sname->name);
      free(sname);
    }
  else
    {
      cname = pop();
      pfnote_c(cname->name, 'c', cname->line, cname->charpos,
	       "");
      free (cname->name);
      free (cname);
    }

}

record_inst()
{
  int n;
  save_ident *cname;
  save_ident *iname;

  if (sp < 2) return;		/* need at least a type and a instance */
  n = sp;
  cname = Stack[0];
  for (n = sp; n > 1; n--)
    {
      iname = pop ();
      pfnote_c (iname->name, 'i', iname->line, iname->charpos,
		cname->name);
      free (iname->name);
      free (iname);
    }
  iname = pop();
  free (iname->name);
  free (iname);			/* get rid of the class name at the bottom */

}

yyerror(s)
char *s;
{
  /* Called only when a syntax error is found by yyparse. */

  /* printf ("%s at line %d\n", s, yylineno); */
  clean_stack();
}

eat_til_match (brack, end_brack)
char brack, end_brack;
{
  int count = 1;
  char c;

  while (count > 0)
    {
      c = input ();
      if (c == end_brack)
        count--;
      else if (c == brack)
        count++;
    }
}

eat_til_either ()
{
  int  ret;
  int  stop;
  int  scope;
  save_ident * i;

  stop = 0;
  scope = 0;

  while (stop == 0)
    {
      ret = yylex();
      switch (ret)
        {
        case TCOMMA:
        case TSEMI:
	  stop = 1;
	  break;
        case TLBRACK:
        case TLBRACE:
	  scope++;
	  break;
        case TRBRACK:
        case TRBRACE:
	  scope--;
	  break;
	case TIDENT:
	  i = pop();
	  free (i->name);
	  free(i);
	  break;
        case YYEOF:		/* End-of-file. Stop at all costs */
	  stop++;
	  scope = 0;
	  break;
	  default:
	  break;
        }
      if (stop && (scope > 0)) stop = 0;
    }
  if (ret != YYEOF) unput(yytext[0]);
}
__YYSCLASS yytabelem yyexca[] ={
-1, 0,
	0, 29,
	-2, 0,
-1, 1,
	0, -1,
	-2, 0,
-1, 54,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
-1, 55,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
-1, 80,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	262, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	274, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
-1, 81,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	262, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	274, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
-1, 82,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
-1, 84,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	262, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	274, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
-1, 85,
	0, 29,
	257, 29,
	258, 29,
	259, 29,
	260, 29,
	261, 29,
	262, 29,
	263, 29,
	264, 29,
	265, 29,
	266, 29,
	267, 29,
	268, 29,
	270, 29,
	271, 29,
	272, 29,
	273, 29,
	274, 29,
	275, 29,
	276, 29,
	277, 29,
	278, 29,
	279, 29,
	280, 29,
	281, 29,
	282, 29,
	283, 29,
	284, 29,
	285, 29,
	286, 29,
	287, 29,
	288, 29,
	289, 29,
	290, 29,
	291, 29,
	-2, 0,
	};
# define YYNPROD 73
# define YYLAST 167
__YYSCLASS yytabelem yyact[]={

    41,    42,    13,    14,    15,    16,    17,    18,    19,    43,
    20,    21,    22,     9,    11,    23,    24,    44,    12,    25,
    26,    27,    28,    30,    45,    31,    32,    46,    33,    34,
    35,    36,    37,    38,    39,    29,    42,    42,    42,    51,
    51,    51,    42,    42,    42,    41,    41,    41,    79,    10,
    96,    94,    70,    70,    63,    77,    42,    85,    68,    68,
    72,    91,    74,    53,    71,    71,    88,    58,    62,    41,
    76,     6,    84,    81,     8,    66,    56,     3,    47,     5,
    75,    48,    68,    52,    57,    80,     4,    67,    49,    40,
     1,    61,     7,     7,     0,     2,    59,    50,     0,     0,
    54,    55,     0,     0,     0,     0,     0,    60,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    65,    69,    64,     0,
     0,     0,    73,    60,     0,     0,     0,    78,     0,     0,
     0,     0,     0,    83,     0,     0,     0,    83,     0,    86,
    87,     0,    89,    90,    69,     0,    92,    93,    73,     0,
    82,     0,     0,    95,    82,     0,    86 };
__YYSCLASS yytabelem yypact[]={

  -256,  -256, -3000, -3000, -3000, -3000, -3000, -3000,  -219,  -215,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000,  -201, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000,  -214, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000,  -206,  -214,  -187,  -209, -3000,  -220,  -214,  -188,
  -205, -3000,  -214, -3000,  -212, -3000, -3000, -3000,  -215, -3000,
 -3000, -3000,  -215,  -206,  -201,  -213, -3000, -3000, -3000, -3000,
  -211,  -211,  -210,  -221,  -211,  -211,  -212,  -207,  -201, -3000,
 -3000,  -201, -3000, -3000, -3000,  -208, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,    90,    95,    76,    86,    79,    74,    89,    91,    71,
    85,    73,    72,    57,    49 };
__YYSCLASS yytabelem yyr1[]={

     0,     1,     1,     1,     1,     1,     1,     1,     1,     3,
     3,     3,     3,     4,     4,     4,     7,    10,     7,    11,
     7,     8,     8,     9,    12,     9,    13,     9,     9,     9,
     9,     5,    14,    14,    14,    14,     6,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2 };
__YYSCLASS yytabelem yyr2[]={

     0,     2,     2,     2,     2,     4,     4,     4,     4,     5,
     7,     7,     9,    11,    13,     7,     6,     1,    10,     1,
    10,     2,     4,     6,     1,    10,     1,    10,     4,     0,
     2,     3,     2,     2,     2,     2,     2,     3,     3,     5,
     7,     7,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -1,    -2,    -3,    -4,    -5,    -9,    -8,    -6,   269,
   -14,   270,   274,   258,   259,   260,   261,   262,   263,   264,
   266,   267,   268,   271,   272,   275,   276,   277,   278,   291,
   279,   281,   282,   284,   285,   286,   287,   288,   289,   290,
    -7,   256,   257,   265,   273,   280,   283,    -3,    -5,    -4,
    -2,   260,    -6,   282,    -8,    -8,    -3,    -6,   282,    -6,
    -6,    -8,   282,   260,    -6,    -9,   262,   274,   269,    -9,
   262,   274,   269,    -6,   282,   268,   258,   260,    -6,   260,
   -10,   -11,    -8,    -6,   -12,   -13,    -6,    -6,   279,    -9,
    -9,   282,    -9,    -9,   258,    -6,   258 };
__YYSCLASS yytabelem yydef[]={

    -2,    -2,     1,     2,     3,     4,    37,    38,    21,    55,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    56,    57,    58,    59,    60,    61,    62,
    63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
    31,    30,    36,    32,    33,    34,    35,     5,     6,     7,
     8,     9,    21,    39,    -2,    -2,    28,    21,     0,     0,
    21,    22,     0,    10,    21,    16,    17,    19,     0,    23,
    24,    26,    41,     0,    40,     0,    15,    11,    21,    12,
    -2,    -2,    -2,    21,    -2,    -2,     0,     0,     0,    18,
    20,     0,    25,    27,    13,     0,    14 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"TIDENT",	257,
	"TLBRACE",	258,
	"TRBRACE",	259,
	"TLPAREN",	260,
	"TRPAREN",	261,
	"TLBRACK",	262,
	"TRBRACK",	263,
	"TOTHER",	264,
	"TAUTO",	265,
	"TCHAR",	266,
	"TCLASS",	267,
	"TCOLON",	268,
	"TCOMMA",	269,
	"TSEMI",	270,
	"TDBLCOLON",	271,
	"TENUM",	272,
	"TEXTERN",	273,
	"TEQUAL",	274,
	"TFLOAT",	275,
	"TFRIEND",	276,
	"TINT",	277,
	"TLONG",	278,
	"TPUBLIC",	279,
	"TREG",	280,
	"TSHORT",	281,
	"TSTAR",	282,
	"TSTATIC",	283,
	"TSTRUCT",	284,
	"TTYPEDEF",	285,
	"TUNION",	286,
	"TUNSIGNED",	287,
	"TVIRTUAL",	288,
	"TVOID",	289,
	"TDEFINE",	290,
	"TNUM",	291,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"something : other",
	"something : function",
	"something : class",
	"something : instance",
	"something : something function",
	"something : something instance",
	"something : something class",
	"something : something other",
	"function : ident TLPAREN",
	"function : ident ident TLPAREN",
	"function : TSTAR ident TLPAREN",
	"function : ident TSTAR ident TLPAREN",
	"class : TCLASS ident TCOLON ident TLBRACE",
	"class : TCLASS ident TCOLON TPUBLIC ident TLBRACE",
	"class : TCLASS ident TLBRACE",
	"inst_head : ident inst_var inst_list",
	"inst_head : ident inst_var TLBRACK",
	"inst_head : ident inst_var TLBRACK inst_list",
	"inst_head : ident inst_var TEQUAL",
	"inst_head : ident inst_var TEQUAL inst_list",
	"inst_var : ident",
	"inst_var : TSTAR inst_var",
	"inst_list : TCOMMA inst_var inst_list",
	"inst_list : TCOMMA inst_var TLBRACK",
	"inst_list : TCOMMA inst_var TLBRACK inst_list",
	"inst_list : TCOMMA inst_var TEQUAL",
	"inst_list : TCOMMA inst_var TEQUAL inst_list",
	"inst_list : TCOMMA function",
	"inst_list : /* empty */",
	"inst_list : error",
	"instance : inst_head",
	"storage : TAUTO",
	"storage : TEXTERN",
	"storage : TREG",
	"storage : TSTATIC",
	"ident : TIDENT",
	"other : inst_list",
	"other : inst_var",
	"other : ident TSTAR",
	"other : TCOMMA ident TSTAR",
	"other : TCOMMA inst_var TCOMMA",
	"other : storage",
	"other : TSEMI",
	"other : TEQUAL",
	"other : TLBRACE",
	"other : TRBRACE",
	"other : TLPAREN",
	"other : TRPAREN",
	"other : TLBRACK",
	"other : TRBRACK",
	"other : TOTHER",
	"other : TCHAR",
	"other : TCLASS",
	"other : TCOLON",
	"other : TCOMMA",
	"other : TDBLCOLON",
	"other : TENUM",
	"other : TFLOAT",
	"other : TFRIEND",
	"other : TINT",
	"other : TLONG",
	"other : TNUM",
	"other : TPUBLIC",
	"other : TSHORT",
	"other : TSTAR",
	"other : TSTRUCT",
	"other : TTYPEDEF",
	"other : TUNION",
	"other : TUNSIGNED",
	"other : TVIRTUAL",
	"other : TVOID",
	"other : TDEFINE",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 66.3 $ */

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */
#ifdef __cplusplus
	extern char *malloc(int);
	extern char *realloc(char *, int);
	extern void free();
# else
	extern char *malloc();
	extern char *realloc();
	extern void free();
# endif /* __cplusplus */
static int allocate_stacks();
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( (nl_msg(30003,"syntax error")) );
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{

case 9:
# line 43 "parser.y"
{record_func();} break;
case 10:
# line 44 "parser.y"
{record_func();} break;
case 11:
# line 45 "parser.y"
{record_func();} break;
case 12:
# line 46 "parser.y"
{record_func();} break;
case 13:
# line 50 "parser.y"
{record_class();} break;
case 14:
# line 53 "parser.y"
{record_class();} break;
case 15:
# line 55 "parser.y"
{record_class();} break;
case 17:
# line 58 "parser.y"
{unput(yytext[0]);eat_til_either();} break;
case 19:
# line 59 "parser.y"
{eat_til_either();} break;
case 24:
# line 66 "parser.y"
{unput(yytext[0]);eat_til_either();} break;
case 26:
# line 67 "parser.y"
{eat_til_either ();} break;
case 31:
# line 73 "parser.y"
{record_inst();} break;
case 37:
# line 83 "parser.y"
{clean_stack();} break;
case 38:
# line 84 "parser.y"
{clean_stack();} break;
case 39:
# line 85 "parser.y"
{clean_stack();} break;
case 40:
# line 86 "parser.y"
{clean_stack();} break;
case 41:
# line 87 "parser.y"
{clean_stack();} break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

