;;; CLASS BROWSER FOR C++
;;; $Id: br-utils.el,v 3.1 1995/02/17 18:19:36 mmann Exp $
;;;
;;; **********************************************************************
;;; Copyright (C) 1993, 1994 Gerd Moellmann. All rights reserved.
;;; Altenbergstr. 6, D-40235 Duesseldorf, Germany
;;; 100025.3303@COMPUSERVE.COM
;;; Suggestions, comments and requests for improvements are welcome.
;;; **********************************************************************
;;;
;;; This version works with both Emacs version 18 and 19, and I want
;;; to keep it that way. It requires the CL-19 Common Lisp compatibility
;;; package for Emacs 18 and 19.
;;;
;;; This file contains utilities related to the class browser.
;;; 

;; This file may be made part of the Emacs distribution at the option
;; of the FSF.

;; This code is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; this code, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

;; To autoload this feature, include the following in your `.emacs':
;;
;; (require 'br-utils)


;;;
;;; Options.
;;;

(defvar browse-option-define-keys t
  "*If set to T binds browser commands to key sequences with prefix
`\C-cb'.")

(defvar browse-option-electric-buffer-list t
  "*If set to T defines function `browse-electric-buffer-list' that 
lists all browse buffers.")

(defvar browse-option-electric-buffer-key t
  "*If set to T defines key `\C-bb' to `browse-electric-buffer-list'.")

(defvar browse-option-install-find-file-hook t
  "*If T install a find file hook that automatically browses buffers
that contain the browse file signature.")


;;;
;;; The following can be used to bind key sequences starting with
;;; prefix `\C-cb' to browse commands.
;;; 

(when browse-option-define-keys
  (defvar browse-global-map ()
    "Keymap used for \C-cb* sequences.")

  (unless browse-global-map
    (let ((submap (make-sparse-keymap)))
      (setq browse-global-map (make-sparse-keymap))
      (define-key browse-global-map "a" 'browse-tags-apropos)
      (define-key browse-global-map "b" 'browse-tags-back)
      (define-key browse-global-map "f" 'browse-tags-forward)
      (define-key browse-global-map "l" 'browse-tags-list)
      (define-key browse-global-map "m" 'browse-tags-find-member-buffer)
      (define-key browse-global-map "n" 'browse-next-file)
      (define-key browse-global-map "p" 'browse-electric-position-list)
      (define-key browse-global-map "s" 'browse-search)
      (define-key browse-global-map "u" 'browse-search-member-usage)
      (define-key browse-global-map "v" 'browse-tags-view)
      (define-key browse-global-map "%" 'browse-query-replace)
      (define-key browse-global-map "." 'browse-tags-find)
      (define-key browse-global-map "," 'browse-loop)
      (define-key browse-global-map "+" submap)
      (define-key submap "r" 'browse-add-region)
      (define-key submap "b" 'browse-add-buffer)
      (define-key global-map "\C-cb" browse-global-map))))


;;;
;;; Electric buffer menu customization to display only some buffers
;;; (in this case Tree buffers).   There is only one problem with this:
;;; If the very first character typed in the buffer menu is a space,
;;; this will select the buffer from which the buffer menu was invoked.
;;; But this buffer is not displayed in the buffer list if it isn`t a tree
;;; buffer.    I therefore let the buffer menu command loop read the
;;; command `p' via `unread-command-char'.   This command has no effect
;;; since we are on the first line of the buffer.
;;; 

(if browse-option-electric-buffer-list
    (progn
      ;; No PROVIDE, no var for hook in there...
      (if (eq system-type 'ms-dos)
          (load "ebuff-me")
        (load "ebuff-menu"))

      (defvar electric-buffer-menu-mode-hook nil)

      (defun browse-hack-electric-buffer-menu ()
	(let (non-empty)
	  (unwind-protect
	      (save-excursion
		(setq buffer-read-only nil)
		(goto-char 1)
		(forward-line 2)
		(while (not (eobp))
		  (let ((b (Buffer-menu-buffer nil)))
		    (if (or (browse-buffer-p b)
			    (string= (buffer-name b) "*Apropos Members*"))
			(progn (forward-line 1) (setq non-empty t))
		      (delete-region (point)
				     (save-excursion (end-of-line)
						     (min (point-max)
							  (1+ (point)))))))))
	  (unless non-empty
	    (error "No tree buffers."))
	  (setq unread-command-char ?p)
	  (shrink-window-if-larger-than-buffer
	   (selected-window))
	  (setq buffer-read-only t))))

      (defun browse-electric-quick-select ()
	(interactive)
	(let* ((maxlin (count-lines (point-min) (point-max)))
	       (n (min maxlin (+ 2 (string-to-int (this-command-keys))))))
	  (goto-line n)
	  (throw 'electric-buffer-menu-select (point))))

      (defun browse-electric-install-quick-keys ()
	(dotimes (i 9)
	  (define-key (current-local-map) (char-to-string (+ i ?1))
	    'browse-electric-quick-select)))

      (defun browse-electric-buffer-list ()
        (interactive)
	(unwind-protect
	    (progn
	      (push 'browse-hack-electric-buffer-menu
		    electric-buffer-menu-mode-hook)
	      (call-interactively 'electric-buffer-list))
	  (pop electric-buffer-menu-mode-hook)))))

(add-hook 'electric-buffer-menu-mode-hook 'browse-electric-install-quick-keys)

(if browse-option-electric-buffer-key
    (define-key browse-global-map " " 'browse-electric-buffer-list))


;;;
;;; Customization of C++ mode. \C-tab or \M-tab is bound to symbol
;;; completion. For Emacs 19, C-M-mouse1 is bound to the same
;;; function as \C-b.
;;;

(require 'br-compl)

(add-hook 'c++-mode-hook
          (function
           (lambda ()
             (cond ((browse-emacs-19-p)
                    (define-key (current-local-map) [C-tab] 
                      'browse-complete-symbol)
                    (define-key (current-local-map) [C-M-mouse-1] 
                      'browse-mouse-member-find))
                   (t
                    (define-key (current-local-map) "\e\C-i"
                      'browse-complete-symbol))))))


(provide 'br-utils)

;;; end of `utils.el'
