/* 
 * toolz.c - Some string processing tools and stuff formerly in translat.c
 *
 * texi2roff history:
 *             Release 1.0a    August 1988
 *             Release 2.0     January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 * texi2ipf history:
 *             Release 1.0     February 1993
 *
 * Modified by Marcus Grber, Fido 2:2402/61.1
 *
 * Modified by Martin "Herbert" Dietze, Email herbert@wiloyee.shnet.org
 *
 */

/*
 * History:
 *
 * $Log: toolz.c,v $
 * Revision 1.1.1.1  1997/07/17 13:49:26  HERBERT
 * Texi2IPF 2.2 new import
 *
 * Revision 1.3  1997/02/06 12:45:18  herbert
 * - Added documentation in Texinfo format.
 * - Minor bug fixes.
 *
 * Revision 1.2  1997/01/17 13:34:36  herbert
 * Use remove_texicmds() when processing menu entries.
 *
 * Revision 1.1  1997/01/16 13:41:33  herbert
 * Put stuff from translat.c to new file toolz.c.
 * Fixed an error in the remove_texicmd() routine (correct handling of "@@",
 * "@{" and "@}" tags).
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "texi2ipf.h"

static char * id =
"@(#)$Id: toolz.c,v 1.1.1.1 1997/07/17 13:49:26 HERBERT Exp $";

extern int     linecount;
extern char   *filename;
char * gettoken( char *, char *);

/*  
 * rtrim - as in dbase - remove trailing whitespaces and returns
 */
char * rtrim( char *s)
{
    int i;

    for( i = strlen( s) - 1; 
         i >= 0 && ( s[i] == ' ' || s[i] == '\t' || s[i] == '\n' );
         i-- )
        s[i] = '\0';
    /* endfor */
    return s;
}/* rtrim() */


/*
 * eatwhitespace - move input pointer to first char that isnt a blank or tab
 *     (note that newlines are *not* whitespace)
 */

char * eatwhitespace( char *s)
{
    if ( !s )
        return NULL;
    /* endif */
    while( *s == ' ' || *s == '\t' )
        ++s ;
    /* endwhile */
    return s;
}/* eatwhitespace() */


/* 
 * errormsg - print error messages to stderr
 */

void errormsg( char *message, char *other)
{
    (void) fprintf( stderr, "%s line %d : %s%s\n",
                    filename, linecount, message, other);
}/* errormsg() */

/*
 * Remove all Texinfo commands starting with "@" from the string.
 */
void remove_texicmds( char * string)
{
    char tmpstr[MAXLINELEN];
    char * strptr;
    char * tmptr  = tmpstr;
    strcpy( tmpstr, string);
    *string = '\0';

    /*
     * Remove all '{'. If "@{" then make '{' out of it.
     */
    tmptr = tmpstr;
    while ( *tmptr ){
        if ( *tmptr == '{' )
            if ( tmptr > tmpstr )
                if ( *(tmptr-1) != '@' )
                    *tmptr = ' ';
                else {
                    tmptr--;
                    *tmptr = '\0';
                    strcat( tmpstr, tmptr+1);
                }/* if */
        /* endif */
        ++tmptr;
    }/* while */

    /*
     * Remove all '}'. If "@}" then make '}' out of it.
     */
    tmptr = tmpstr;
    while ( *tmptr ){
        if ( *tmptr == '}' ){
            if ( tmptr > tmpstr )
                if ( *(tmptr-1) != '@' ){
                    *tmptr = '\0';
                    strcat( tmpstr, tmptr+1);
                    continue;
                } else {
                    *(tmptr-1) = '\0';
                    strcat( tmpstr, tmptr);
                }/* if */
            else{
                *tmptr = '\0';
                strcat( tmpstr, tmptr+1);
                continue;
                }/* if */
        } /* if */
        tmptr++;
    }/* while */
    
    /*
     * Now cat the copy of the string back to the string leaving out
     *  all words starting with '@' but making '@' out of "@@".
     */
    tmptr = eatwhitespace( tmpstr);
    strptr = tmptr;
    while ( *tmptr ){
        while ( *tmptr && *tmptr != '@' && !isspace( *tmptr) )
            ++tmptr;
        /* endwhile */
        strncat( string, strptr, (unsigned long)tmptr - (unsigned long)strptr);
        /*
         * EOS? Exit.
         */
        if ( !*tmptr ){
            return;
        }/* if */
        /*
         * Now we're at the first whitespace.
         * Append *one* whitespace and skip the rest.
         */
        if ( isspace( *tmptr) ){
            strcat( string, " ");
            while ( *tmptr && isspace( *tmptr) )
                ++tmptr;
            /* endwhile */
        }/* if */
        /*
         * Found '@'? Find its end (must be a whitespace).
         */
        if ( *tmptr == '@' ){
            if ( *(tmptr+1) == '@' ){
                *tmptr = '\0';
                strcat( tmpstr, tmptr+1);
                strcat( string, "@");
                if ( isspace( *(++tmptr)) )
                    strcat( string, " ");
                /* endif */
                while ( isspace( *tmptr ) )
                    tmptr++;
                /* endwhile */
                strptr = tmptr;
                continue;
            }/* if */
            while ( *tmptr && !isspace( *tmptr) )
                ++tmptr;
            /* endwhile */
            if ( !*tmptr )
                return;
            /* endif */
            while ( *tmptr && isspace( *tmptr) )
                ++tmptr;
            /* endwhile */
            if ( !*tmptr )
                return;
            /* endif */
        }/* endif */
        strptr = tmptr;
    }/* while */
    
}/* remove_texicmds() */


/*
 * Consume the first word and leading blanks. Expressions in {...} are
 * considered as one word.
 */
char * eat_first_word( char * string)
{
    if ( *(string = eatwhitespace( string)) == '\0' )
        return string;
    /* endif */
    if ( *string == '{' ){
        int bo = 1;
        int bc = 0;
        do{
            ++string;
            if ( *string == '{' )
                ++bo;
            else if ( *string == '}' )
                ++bc;
        } while ( *string && (bo != bc) );
        if ( *string == '}' )
            ++string;
    } else {
        do
            ++string;
        while ( (*string != ' ')
                && (*string != '\t')
                && *string );
    }/* if */
    if ( !(*string) )
        return string;
    /* endif */
    return eatwhitespace( string);
}/* eat_first_word() */

/*
 * This translates a menu entry sub string to ipf. Because we're inside
 * a menu entry we ignore any @... commmand! It would get too complicated
 * otherwise :-)
 */
void translate_string( char *string)
{
    char token[MAXLINELEN];
    char tmpout[MAXLINELEN*2];
    char * ptr = tmpout;
    int i = 0;

    if ( !string[i] ){
        return;
    }/* if */
    
    while ( (string[i] == ' ')
            || (string[i] == '\t')
            || (string[i] == '\n') ){
        if ( !string[i] ){
            return;
        }/* if */
        i++;
    }/* while */
    strcpy( tmpout, string);
    string[0] = '\0';
    
    do{
        ptr = gettoken( ptr, token);
        strcat( string, token);
    }while( *ptr );

}/* translate_string() */


/*
 * Find out if the current string is a menu entry. If no return 0.
 * Else create a ipf menu entry and return 1.
 */
int menu_entry_maybe( char *input, char *output)
{
    char tmpbuf[MAXLINELEN*2];
    char * double_colon;
    if ( *input != '*' )
        return 0;
    /* endif */
    input++;
    if ( (double_colon = strstr( input, "::")) == NULL )
        return 0;
    /* endif */
    double_colon[0] = '\0';
    
    input = eatwhitespace( input);
    double_colon = eatwhitespace( double_colon+2);

    strcpy( tmpbuf, double_colon);
    translate_string( input);
    remove_texicmds( input);
    translate_string( tmpbuf);
    remove_texicmds( tmpbuf);
    
    sprintf( output, "%s%s%s%s%s%s\n%c", 
             ":pt.:link reftype=hd refid='", input, "'.", input, 
             ":elink.:pd.", tmpbuf, '\0');
    return 1;
}/* menu_entry_maybe() */

