/*

**++

** $Id: texi2i.cmd,v 1.1.1.1 1997/07/17 13:49:26 HERBERT Exp $

**

** REXX: texi2i.cmd

**

** FUNCTION:

**	converts a texinfo file to an OS/2 INF file

**	and creates a program object for it on the desktop

**

** USES:

**

** AUTHOR: Hans-Michael Stahl <hmstahl@berlin.snafu.de>

**

** CREATED: 14-Feb-1097

**

** $Log: texi2i.cmd,v $
** Revision 1.1.1.1  1997/07/17 13:49:26  HERBERT
** Texi2IPF 2.2 new import
**

**--

**/



/* set up handlers for error situations */

   signal on Syntax

   signal on Halt

   signal on Novalue



/* load support functions */



   /* REXX utility functions */

   rc = rxfuncadd('sysLoadFuncs', 'REXXUTIL', 'sysLoadFuncs')

   rc = sysLoadFuncs()



/* Main program goes here */



   /* check environment */

   ipfc = value('IPFC',, 'OS2ENVIRONMENT')

   if ipfc = '' then do

     say  '*Warning*: The IPFC environment variable should be set to the IPFC'

     say  'subdirectory (normally in TOOLKT20) for IPFC to work correctly.'

     exit 1

   end



   /* Get general information */

   parse source opSys mode procedureName

 

   /* get arguments */

   parse arg texiFile options

   if texiFile = '' then do

     call usage

     exit 1

   end



   /* parse options */

   delete = 1

   object = 1



   do i = 1 to words(options)

      opt = translate(word(options, i))

      if left(opt, 1) <> '/' & left(opt,1) <> '-' then iterate

      else opt = substr(opt, 2)

      if abbrev('KEEP', opt, 1) then delete = 0

      if abbrev('NOOBJECT', opt, 3) then object = 0

   end /* do */

   

   /* search texinfo file */

   if lastpos('.', filespec('Name', texiFile)) = 0 then

      rc = SysFileTree(texiFile'.tex*', 'files', 'FO', )

   else

      rc = SysFileTree(texiFile, 'files', 'FO', )

   if files.0 = 0 then do

      say 'No matching file found.'

      exit 1

   end

   if files.0 > 1 then do

      say 'Too many matching files found; be more specific.'

      exit 1

   end

   texiFile = files.1



   /* now convert */

   texiName = files.1

   name = filespec('name', texiName)

   path = filespec('drive', texiName)||filespec('path', texiName)

   basename = substr(name, 1, lastpos('.', name)-1)

   ipfName = path||basename'.ipf'



   '@texi2ipf' texiName '>' ipfName 

   if rc <> 0 then do

      say 'TEXI2IPF failed with return code' rc

      exit 1

   end

   '@ipfc' ipfName '/INF /S'

   if rc <> 0 then do

      say 'IPFC failed with return code' rc

      exit 1

   end

   if delete then rc = sysFileDelete(ipfName)

   else say 'IPF file kept in 'ipfName '(option /KEEP specified)'



   /* create program object */

   if object then do

      location = '<WP_DESKTOP>'

      program = 'EXENAME=VIEW.EXE;PARAMETERS='basename';STARTUPDIR='path

      rc = SysCreateObject("WPProgram", basename , location, program, "f")

      if rc then say 'Object "'basename'" created on desktop'

      else say 'Could not create object "'basename'" on desktop'

   end

   else say 'No object created on desktop (option /NOOBJECT specified)'

      

   exit



usage:

   say ''

   say 'Usage: 'procedureName' file [/option...]'

   say ''

   say '  If you do not specify an extension we search for "file.tex*"'

   say '  Option /K[EEP] keeps the IPF source file'

   say '  Option /NOO[BJECT] does not generate a desktop object'

   return







/* procedures */

Syntax:

   say 'A SYNTAX condition was raised on line' sigl'!'

   say '  The error number is' rc', which means "'errortext(rc)'"'

   problem_line = sigl

   signal Abnormal_End



Halt:

   say 'A Halt condition was raised on line' sigl'!'

   problem_line = sigl

   rc = 99

   Signal Abnormal_End



Novalue:

   say 'Novalue Condition raised on line' sigl'!'

   say '  The variable which caused it is' condition('Description')

   problem_line = sigl

   signal Abnormal_End



Abnormal_End:

   Say '  That line is "'Sourceline(problem_line)'"'

   exit rc

