/* REXX: nroff.cmd */

/* Author:  Kai Uwe Rommel <rommel@ars.de>
 * Created: Wed May 01 1996
 */

/* Emulate nroff with groff. */

Parse Source . . name
name = FileSpec('n',name)
name = Left(name,Length(name) - 4)

T = '-Tascii'
opts = ''

Parse Arg args

Do i=1 To Words(args)

  opt = Word(args, i)

  Select
    
    When opt = '-e' | opt = '-q' | Left(opt, 2) = '-s' | Left(opt, 2) = '-u' 
    Then Iterate
    
    When opt = '-m' | opt = '-r' | opt = '-n' | opt = '-o' | opt = '-T' 
    Then Do
      Say name': option 'opt' requires an argument'
      Exit 1
    End
    
    When opt = '-h' 
    Then Do
      opts = opts' -P-h'
      Iterate
    End
    
    When opt = '-i' 
    Then Do
      opts = opts' 'opt
      Iterate
    End
    
    When Left(opt, 2) = '-m' | Left(opt, 2) = '-r' |,
         Left(opt, 2) = '-n' | Left(opt, 2) = '-o' 
    Then Do
      opts = opts' 'opt
      Iterate
    End
    
    When opt = '-Tascii' | opt = '-Tlatin1' 
    Then Do
      T = opt
      Iterate
    End
    
    When Left(opt, 2) = '-T' 
    Then Iterate
    
    When Left(opt, 2) = '--' 
    Then Do
      i = i +1
      Leave
    End
    
    When opt = '-' 
    Then Leave
    
    When Left(opt, 1) = '-' 
    Then Do
      Say name': invalid option 'opt
      Exit 1
    End
    
    Otherwise
      Leave

  End

End

'@groff -Wall -mtty-char 'T' 'opts' 'SubWord(args, i)

/* end of nroff.cmd */
