;;; tex-site.el - Site specific variables.

;; FIRST: emx-specific things

(setq emx-TeX-command "f:/texte/tex/bin/tex386")
(setq TeX-shell (if (eq emx-system-type 'os2) "cmd.exe" "command.com"))
(setq TeX-lisp-directory "f:/emacs/auctex/")
(setq TeX-macro-global '("f:/texte/tex/texinput/"))
(setq TeX-print-command "f:/texte/tex/bin/prthpdj %s")
(setq TeX-printer-list '(("dj" "prthpdj %s")
                         ("fx" "prtfx %s")
                         ("ps" "dvips -o lpt1 %s")))
(setq TeX-view-style
      (list (list "." (if (eq emx-system-type 'os2)
                          "f:/texte/tex/bin/vp %d" "v %d"))))
(setq TeX-command-list
      (list (list "TeX" "tex386 \\nonstopmode\\input %t" 'TeX-run-TeX nil t)
            (list "TeX Interactive" "tex386 %t" 'TeX-run-interactive nil t)
            (list "LaTeX" "%l \\nonstopmode\\input{%t}" 'TeX-run-LaTeX nil t)
            (list "LaTeX Interactive" "%l %t" 'TeX-run-interactive nil t)
            (list "LaTeX2e" (emx-make-TeX-command
                             "&latex \\nonstopmode\\input{%t}")
                  'TeX-run-LaTeX nil t)
            (list "View" "%v @dj /fl=-1 +scaling:2 +zoom:2" 'TeX-run-background t nil)
            (list "Print" "%p " 'TeX-run-command t nil)
            (list "BibTeX" "bibtex %s" 'TeX-run-BibTeX nil nil)
            (list "Index" "makeindx %s" 'TeX-run-command nil t)
            (list "Check" "lacheck %s" 'TeX-run-compile nil t)
            (list "Spell" "<ignored>" 'TeX-run-ispell nil nil)
            (list "Other" "" 'TeX-run-command t t)
            ;; Not part of standard TeX.
            (list "Makeinfo" "makeinfo %t" 'TeX-run-compile nil t)
            (list "AmSTeX" "tex386 ^&amstex \\nonstopmode\\input %t"
                  'TeX-run-TeX nil t)))

(setq LaTeX-command-style
      (mapcar (function (lambda (arg)
                          (list (car arg)
                                (emx-make-TeX-command (nth 1 arg)))))
              '(("^ams" "&amslatex")
                ("^foils$" "&foiltex")
                ("^slides$" "&splain")
                ("^plfonts\\|plhb$" "&platex")
                ("." "&lplain"))))





;; SECOND: All the rest
;; Copyright (C) 1991 Kresten Krab Thorup 
;; Copyright (C) 1993, 1994 Per Abrahamsen 

;; Author: Per Abrahamsen <abraham@iesd.auc.dk>
;; Maintainer: AUC TeX Managers <auc-tex_mgr@iesd.auc.dk>
;; Version: $Id: tex-site.el,v 5.76 1995/01/24 22:52:52 amanda Exp $
;; Keywords: wp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; This file contains variables customized for the local site.

;; It also contains all necessary autoloads, so the user can simple
;; enable AUC TeX by putting (load "tex-site") in his .emacs file,
;; or the administrator can insert it in the site-start.el file.
;;
;; The ideal place for this file is in the `site-lisp' directory.

;;; Code:

(defvar no-doc
  "This function is part of AUC TeX, but has not yet been loaded.
Full documentation will be available after autoloading the function."
  "Documentation for autoload functions.")

;;; Customization:
;;
;; Copy variables you need to change from the start of `tex.el' and
;; insert them here.

(defvar TeX-lisp-directory "/usr/local/lib/emacs/site-lisp/auctex/"
  "*The directory where the AUC TeX lisp files are located.")

;;; Autoloads:

(or (assoc TeX-lisp-directory (mapcar 'list load-path))	;No `member' yet.
    (assoc (substring TeX-lisp-directory 0 -1) ;Without trailing slash.
	   (mapcar 'list load-path))
    (setq load-path (cons TeX-lisp-directory load-path)))

;; This hook will store bibitems when you save a BibTeX buffer.
(defvar bibtex-mode-hook nil)
(or (memq 'BibTeX-auto-store bibtex-mode-hook) ;No `add-hook' yet.
    (setq bibtex-mode-hook (cons 'BibTeX-auto-store bibtex-mode-hook)))

(autoload 'BibTeX-auto-store "latex" no-doc t)

;; Bind latex-help globally. 
(autoload 'latex-help "ltx-help" no-doc t)
(define-key help-map "\C-l" 'latex-help)

(autoload 'tex-mode "tex" no-doc t)
(autoload 'plain-tex-mode "tex" no-doc t)
(autoload 'ams-tex-mode "tex" no-doc t)
(autoload 'TeX-auto-generate "tex" no-doc t)
(autoload 'TeX-auto-generate-global "tex" no-doc t)
(autoload 'TeX-insert-quote "tex" no-doc t)
(autoload 'TeX-submit-bug-report "tex" no-doc t)
(autoload 'japanese-plain-tex-mode "tex-jp" no-doc t)
(autoload 'japanese-latex-mode "tex-jp" no-doc t)
(autoload 'japanese-slitex-mode "tex-jp" no-doc t)
(autoload 'texinfo-mode "tex-info" no-doc t)
(autoload 'latex-mode "latex" no-doc t)

(provide 'tex-site)

;;; tex-site.el ends here
