/* 
 * Make a distribution of THE
 * Required for those platforms that use GNU make:
 *   DOSDJP
 *   OS2EMX - Regina
 *   OS2OS2 - OS/2 Rexx
 *   DOSEMX
 */
Parse Arg ver verdot platform src reg
If ver = '' Then Call usage
'mkdir tmp'
'cd tmp'
'del /Y *.*'
'copy ..\the.exe .'
'copy' src || '\THE_Help.txt .'
'copy' src || '\demo.txt .'
'copy' src || '\*.the .'
'copy' src || '\COPYING .'
'copy' src || '\HISTORY .'
'copy' src || '\TODO .'
'copy' src || '\README .'
select
  when platform = 'DOSDJG' then do
       if reg = '' then call usage
       'copy' src || '\dosgo32.diz file_id.diz'
       'copy' reg || '\go32.exe .'
       int = ''
       suffix = 'djg'
       interpreter = 'Regina'
       end
  when platform = 'DOSEMX' then do
       if src = '' then call usage
       'copy' src || '\dosvcpi.diz file_id.diz'
       int = ''
       suffix = 'vcp'
       interpreter = 'Regina'
       end
  when platform = 'OS2EMX' then do
       if reg = '' then call usage
       'copy' src || '\os2.diz file_id.diz'
       'copy' reg || '\regina.dll .'
       int = 'R'
       suffix = '_os2'
       interpreter = 'Regina'
       end
  when platform = 'OS2OS2' then do
       'copy' src || '\os2.diz file_id.diz'
       int = 'O'
       suffix = '_os2'
       interpreter = 'OS/2 Rexx'
       end
   otherwise call usage
end
'c:\bin\the -b -p' src || '\fix.diz -a "' || ver verdot int interpreter '" file_id.diz'
'zip the' || ver || int || suffix '*'
'cd ..'
Return

usage:
Say 'makedist version versiondot platform src reg'
Say 'where:'
Say '      version    - 25'
Say '      versiondot - 2.5'
Say '      platform   - one of DOSDJG DOSEMX OS2EMX OS2OS2'
Say '      src        - source of THE'
Say '      reg        - directory where regina.dll or go32.exe is'
Exit 1
