/* Install.cmd */

call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
call SysLoadFuncs

/*
 *  Ermitteln der Environments von EmTeX und setzen der Installations-
 *  Pfade fr TeXEdit
 */
    env = VALUE('emtexdir',,'OS2ENVIRONMENT')
    env2 = Left( env, 2)

    Pfad.0 = 3
    if SysIni( "USER", "TeXEditor", "Pfad" ) \= 'ERROR:' then
        Pfad.1 = SysIni( "USER", "TeXEditor", "Pfad" )
    else
        Pfad.1 = env2||"\TeXEdit"
    Pfad.2 = env"\DLL"
    Pfad.3 = env||'\book\german'

/*
 *  Installationsprozedur
 */
    cls
    say '                            FSS - TeX Editor'
    say '                              Installation  '
    say ' '
    say ' '
    say 'Willkommen im FSS - Tex Editor.'
    say ' '
    say 'Im Laufe der Installationsprozedur mssen einige Angaben zu den'
    say 'gewnschten Installationsverzeichnissen gemacht werden. Bitte'
    say 'geben Sie diese ohne abschlieenden Backslash (\) ein und ver-.'
    say 'gessen Sie nicht die Laufwerksangabe vor dem Pfad'
    say ' '

    say ' '
    say 'In welches Verzeichnis soll TeXEdit Installiert werden? Achten'
    say 'Sie hier bitte auf eine Laufwerksangabe vor dem Pfad (LW:\Pfad)'
    say '[ENTER fr :'||Pfad.1||']'
    pull tmp
    if tmp \= '' then Pfad.1 = tmp
    ok = SysIni( "USER", "TeXEditor", "Pfad", Pfad.1 )

    say ' '
    say 'In welches Verzeichnis soll die DLL-Datei installiert werden?'
    say '[ENTER fr :'||Pfad.2||']'
    pull tmp
    if tmp \= '' then Pfad.2 = tmp

    say ' '
    say 'In welches Verzeichnis sollen die INF-Dateien installiert werden?'
    say '[ENTER fr :'||Pfad.3||']'
    pull tmp
    if tmp \= '' then Pfad.3 = tmp

    do i = 1 to Pfad.0
        call SysFileTree Pfad.i, 'tmp', 'D'
        if tmp.0 = 0 then do
            ok = SysMkDir(Pfad.i)
            if ok \= 0 then do
                say 'FEHLER: Verzeichnis '||Pfad.i||'konnte nicht erstellt werden.'
                exit
            end
        end
    end

    say ' '
    say 'Ist TeXEdit der Version 0.97 oder kleiner bereits auf Ihrem Rechner'
    say 'Installiert? [j|n]'
    pull char
    call SysIni 'USER', 'TeXEditor', 'SW_17pos', 'DELETE:'
    call SysIni 'USER', 'TeXEditor', 'set_SL', 'DELETE:'
    if char = 'j' then do
        W.0 = 6
        W.1 = '2'
        W.2 = '5'
        W.3 = '6'
        W.4 = '7'
        W.5 = '13'
        W.6 = '16'
        do i = 1 to W.0
            call SysIni 'USER', 'TeXEditor', 'SW_'||W.i||'pos', 'DELETE:'
        end
    end

    Datei.0 = 6
    Datei.1 = '*.exe'
    Datei.2 = '*.txt'
    Datei.3 = '*.cmd'
    Datei.4 = '*.ico'
    Datei.5 = '*.TeV'
    Datei.6 = '*.cmd'

    do i = 1 to Datei.0
        '@copy '||Datei.i||' '||Pfad.1
    end

    '@copy *.dll '||Pfad.2
    '@copy *.inf '||Pfad.3


/*
 *  Anlegen der Objekte auf dem Desktop
 */
    say ' '
    say 'Aus welchem Verzeichnis soll TeXEdit starten? [ENTER fr keines]'
    pull StartUpDir

    object.0 = 6
    object.1 = 'EXENAME='||Pfad.1||'\TeXEdit.exe;STARTUPDIR='||StartUpDir
    object.2 = 'EXENAME='||Pfad.1||'\TeXEdit.exe;STARTUPDIR='||StartUpDir||';PARAMETERS=-p'
    object.3 = 'EXENAME=View.exe;PARAMETERS=TeXEdit.INF'
    object.4 = 'EXENAME=e.exe;PARAMETERS='||Pfad.1||'\Neu.txt'
    object.5 = 'EXENAME='||Pfad.1||'\Register.exe'
    object.6 = 'EXENAME=e.exe;PARAMETERS='||Pfad.1||'\Register.txt'

    caption.1 = 'TeXEditor'
    caption.2 = 'PreLoad'
    caption.3 = 'Hilfe'
    caption.4 = 'Neu'
    caption.5 = 'Registrieren'
    caption.6 = 'Registrationsformular'

    if SysCreateObject("WPFolder", "FSS-TeXEditor", "<WP_DESKTOP>",,
        "OBJECTID=<MEINORDNER>") Then nop
    do i = 1 to object.0
        If SysCreateObject("WPProgram", caption.i, "<MEINORDNER>",,
            object.i)  Then a = 1
    end
    If SysCreateObject("WPProgram", "TeXEditor", "<MEINORDNER>",,
        'ASSOCFILTER=*.TEX,*.TEV', "update" )  Then a = 1

    say ' '
    say 'Folgende Umgebungen mssen in der CONFIG.SYS gesetzt sein:'
    say '   '||Pfad.1||' mu in <path>.'
    say '   '||Pfad.2||' mu in <libpath>.'
    say '   '||Pfad.3||' mu in <bookshelf>.'
    say 'Sollen die nderungen automatisch durchgefhrt werden? [j|n]'
    pull char
    if (char = 'n') | (char = 'N') then exit

/*
 *  ndern der CONFIG.SYS
 */
    env = VALUE('USER_INI',,'OS2ENVIRONMENT')
    env = Left( env, 2)

    search.0 = 3
    search.1 = 'SET PATH'
    search.3 = 'SET BOOKSHELF'
    search.2 = 'LIBPATH'

    do while lines( env||'\config.sys') > 0
        line = LineIn( env||'\config.sys')
        tmp = TRANSLATE( line)
        do i = 1 to search.0
            if pos( search.i, tmp) > 0 then do
                pos = Pos( TRANSLATE( Pfad.i)||';', tmp)
                if pos = 0 then do
                    do while (Right( tmp, 1) = ' ') | (Right( tmp, 1) = ';')
                        l = length(tmp)
                        tmp = SubStr(tmp, 1, l - 1)
                        line = SubStr(line, 1, l - 1)
                    end
                    line = line||';'||Pfad.i||';'
                end
            end
        end
        call LineOut env||'\config.new', line
    end
    call LineOut env||'\config.sys'
    call LineOut env||'\config.new'

    '@copy '||env||'\config.sys '||env||'\config.old'
    '@copy '||env||'\config.new '||env||'\config.sys'
    '@del '||env||'\config.new'

    cls
    say ' '
    say 'Die Installation wurde erfolgreich beendet. Die ursprngliche'
    say 'CONFIG.SYS wurde als CONFIG.OLD gesichert.'
    say ' '
    say 'Bitte fhren Sie einen Systemabschlu durch, um die nderungen'
    say 'wirksam werden zu lassen.'


