/* util.h: header file for utilities and stuff that uses utilities
 * C Durland	Public Domain
 */

#ifndef __UTIL_H_INCLUDED
#define __UTIL_H_INCLUDED

#define CAD	/* Craig's stuff is available */

/* ***************************************************************** */
/* ************** files and file io ******************************** */
/* ***************************************************************** */

#define STDIN 0
#define STDOUT 1
#define STDERR 2

/* ***************************************************************** */
/* ************** spew stuff *************************************** */
/* ***************************************************************** */

#define crlf() write(STDOUT,"\r\n",2)
#define fspews(string,filedes) write(filedes,string,strlen(string)) /* fputs*/
#define spew(string) fspews(string,STDOUT) /* puts with no added \n */
#define spewj(string,width,left_just) fspewj(STDOUT,string,width,left_just)

#ifdef USESPEW
#define printf spewf
#define putchar spewc
#define puts spews
#endif

/* ***************************************************************** */
/* ************** time and date ************************************ */
/* ***************************************************************** */

typedef struct
{
  int month, day, weekday, year;  /* year is 4 digits. year%100 for last 2 */
  int hh, mm, ss;
} TIMEDATE;

/* ***************************************************************** */
/* ************** misc handi stuff ********************************* */
/* ***************************************************************** */

#define cm_to_i(cm) ((cm)/2.54)
#define i_to_cm(inches) ((inches)*2.54)

#ifndef PI
#define PI 3.14159265
#endif

	/* convert degrees to radians and vice versa */
#define d_to_r(angle) ((angle)*PI/180.0)
#define r_to_d(angle) ((angle)*180.0/PI)

#endif	/* __UTIL_H_INCLUDED */
