/* ssort.c : a general shell sort
 * Same parameters as qsort(3)
 * Input:
 *   list:  a list of objects to be sorted
 *   items:  number of objects in the list
 *   item_size:  sizeof(object)
 *   cmp:  routine that compares two objects.  Its passed pointers the
 *     objects to be compared.
 *     It returns: <0 if a < b, 0 if a == b, >0 if a > b
 * Output:  a sorted list.
 * C Durland  10/89	Public Domain
 */

#define LIST(j) (list +(j)*item_size)

#ifdef __STDC__
void ssort(char *list, int items, int item_size, int (*cmp)(char *, char *))
#else
void ssort(list,items,item_size,cmp)
  char *list;
  int items, item_size;
  int (*cmp)();
#endif
{
  char buf[128];    /* !!! Must be at least item_size bytes. Should malloc() */
  register int gap, i, j;

  for (gap = items/2; gap; gap /= 2)
    for (i = gap; i < items; i++)
      for (j = i-gap; j >= 0; j -= gap)
      {
	if ((*cmp)(LIST(j),LIST(j+gap)) <= 0) break;
	memcpy(buf,LIST(j),item_size);
	memcpy(LIST(j),LIST(j+gap),item_size);
	memcpy(LIST(j+gap),buf,item_size);
      }
}

#ifdef TEST

#define N 20
int list[N];

int icmp(a,b) int *a,*b; { return *a -*b; }

main()
{
  int j;

  for (j = 0; j<N; j++) list[j] = rand();
  ssort((char *)list,N,sizeof(int),icmp);
  for (j = 0; j<N; j++) printf("list[%d] = %d\n",j,list[j]);
}

#endif
