/* 
 * spoof.c : kinda like sprintf
 *	Craig Durland 8/87 modified from spewf	Public Domain
 *	3/92 added stdarg support
 */

#ifdef __STDC__

#include <stdarg.h>
#define VA_START va_start

#else	/* __STDC__ */

#include <varargs.h>
#define VA_START(a,b) va_start(a)

#endif

#include "const.h"

#define BLANKS \
 "                                                                                "
/*12345678901234567890123456789012345678901234567890123456789012345678901234567890*/

static void fillit(buf,string,width,left_just)
  char *buf, *string; int width, left_just;
{
  int len = strlen(string);

  if (width == 0 || width > 80 || len == width) strcat(buf,string);
  else
    if (width < len) strncat(buf,string,width);
    else
      if (left_just) { strcat(buf,string); strncat(buf,BLANKS,width-len); }
      else { strncat(buf,BLANKS,width-len); strcat(buf,string); }
}

#ifdef __STDC__
char *spoof(char *buf, char *format, ...)
#else
char *spoof(buf,format,va_alist) char *buf, *format; va_dcl
#endif
{
  extern char *i_to_a(), *l_to_a(), *tobase();

  char c[2];
  int left_just, width;
  long x;

  va_list varptr;

  VA_START(varptr, format);

  *buf = c[1] = '\0';	/* for %c */
  while (*format)
  {
    switch (*format)
    {
      case '%': left_just = FALSE; width = 0;
    more:	/* process some more of '%' */
        switch (*++format)
        {
	  case '%': strcat(buf,"%"); break;
	  case '-': left_just = TRUE; goto more;
	  case 'c': c[0]=va_arg(varptr,int);
		fillit(buf,c,width,left_just); break;
	  case 'd': fillit(buf,i_to_a(va_arg(varptr,int)),width,left_just);
		break;
	  case 'l':	/* 'd' only */
		fillit(buf,l_to_a(va_arg(varptr,long)),width,left_just);
		format++; break;
	  case 's': fillit(buf,va_arg(varptr,char *),width,left_just);
		 break;
	  case 'u':
		x = (long)va_arg(varptr,unsigned int);
		fillit(buf,l_to_a(x),width,left_just);
		break;
	  case 'x':
		fillit(buf,tobase((long)va_arg(varptr,unsigned int),16),
			width,left_just);
		break;
	  case '0': case '1': case '2': case '3': case '4': case '5':
	  case '6': case '7': case '8': case '9':
		width = width*10 +*format -'0'; goto more;
	  case '\0': format--; break;	/* format not finished => ignore */
	  default:	 /* copy %<char not matched> */
		strcat(buf,"%"); *c = *(format-1); strcat(buf,c);
        }
	break;
      default: *c = *format; strcat(buf,c);
    }
    format++;
  }

  va_end(varptr);
  return buf;
}






/* ****************  TEST ********************* */
#ifdef TEST

main()
{
  char buf[200];

  puts(spoof(buf, "This is a %s %d", "test", 123));
}

#endif
