/* 
 * sheap.c : string heaps
 * C Durland 3/93 Public Domain
 * cc -g -o sheap sheap.c -DTEST
 */

#include "const.h"

extern char *malloc(), *strcpy();

static int new_size = 1000;

int sheap_size(n)
{
  if (n > 100) new_size = n;
  return new_size;
}

typedef struct SHeap
{
  int size, max;
  struct SHeap *next;
  char text[1];
} SHeap;

char *sheap_add(heap, text) SHeap **heap; char *text;
{
  char *t;
  int len;
  SHeap *ptr = *heap;

  if (ptr == NULL)
  {
    if (NULL == (ptr = (SHeap *)malloc(sizeof(SHeap) + new_size - 1)))
	return NULL;
    ptr->max  = new_size;
    ptr->size = 0;
    ptr->next = NULL;
    
    *heap = ptr;
    return sheap_add(heap, text);
  }

  len = strlen(text) + 1;
  while (ptr)
  {
    if (ptr->max < ptr->size + len)	/* text won't fit in this heap */
    {
      ptr = ptr->next;
      continue;
    }
    t = strcpy(ptr->text + ptr->size, text);
    ptr->size += len;

    return t;
  }

	/* text won't fit in an existing heap, make a new one */
/*if (new_size < len) return NULL;	/* too big == too bad */
  if (t = sheap_add(&ptr, text))	/* note that ptr == NULL */
  {
    ptr->next = *heap;
    *heap = ptr;

    return t;
  }

  return NULL;		/* couldn't do it */
}

int sheap_reset(heap) SHeap *heap;
{
  for (; heap; heap = heap->next) heap->size = 0;

  return TRUE;
}


/* *********************** TEST **************************** */
#ifdef TEST

SHeap *heap = NULL;	/* or void * or char * */
char *list[200];

main(argc, argv) char **argv;
{
  char *ptr;
  int i,j;

  if (argc == 1)
  {
    printf("sheap <string> <string> ....\n");
    exit(1);
  }
  for (j = 0; --argc; j++)
  {
    if (!(list[j] = sheap_add(&heap, argv[j+1])))
    {
      printf("sheap_add() failed!\n");
      exit(1);
    }
  }
  for (i = 0; i < j; i++) printf("[%d] : %s\n", i, list[i]);
}

#endif	/* TEST */
