/* ranger2.c
 * ranger2:
 *   This routine cruises through a sorted list of strings and picks a range
 *     that word falls in.
 *   Blank ("") entries are skipped.
 *   "" does NOT match "".
 *
 * Input:
 *   mover:  Pointer to a function returning a int.
 *     Called to move though the list:
 *       mover(0, (char **)NULL)
 *         Rewind the pointer to the begining of the list.  Doesn't return
 *           anything.
 *       mover(1, (char **)ptr)
 *         Set ptr to point to the key.
 *         Returns:
 *           0 : At the end of the list (ptr not valid).
 *           1 : OK and ptr is valid.
 *     Note:  mover(0, (char **)NULL); mover(1, &ptr); returns a pointer to
 *       the first entry in the list.
 *   word:  What we are looking for in the list.
 *   matched:  Pointer to int.
 *   commonchars:  Pointer to buffer.
 * Output:
 *   matched:  number of characters in word ALSO in at least one item in
 *     list.
 *   commonchars:  given the range word falls in, these are the letters in
 *     common in the range.
 * Returns: TRUE if word is in list else FALSE
 *
 * Fact: The number of letters in commonchars >= matched.
 *
 * Alg:
 *  1. find the max letters in word also in list (match-word)
 *  2. find the range of words in list that have match-word in them
 *  3. find max letters in common in range.
 * C Durland, modified from ranger1.c 1/93
 */

/* Copyright 1989-1993 Craig Durland
 *   Distributed under the terms of the GNU General Public License.
 *   Distributed "as is", without warranties of any kind, but comments,
 *     suggestions and bug reports are welcome.
 */

#include <const.h>

#define REWIND	0
#define NEXT	1

ranger2(mover,word,matched,commonchars)
  pfi mover; int *matched; char *word, *commonchars;
{
  char *a = NULL, *b = NULL, c, *ptr;
  register int len, s;

  *commonchars = '\0'; *matched = 0;
  if (0 == (len = strlen(word))) return FALSE;	/* "" don't match nuthing */
tryagain:
  mover(REWIND, (char **)NULL);
  while (TRUE)
  {
    if (!mover(NEXT, &ptr)) break;
    if (*ptr == '\0') continue;			/* ignore blank entries */
    if (0 == (s = strncmp(word,ptr,len)))	/* len characters match */
      if (a == NULL) a = ptr;	/* the start of the matched words */
      else b = ptr;		/* the end of the range */
    else
      if (s < 0) break;  /* don't search entire list if don't have to */
  }

  if (a == NULL)			/* no match in the list */
    if (0 < len)	/* is there a match on the first n-1 characters? */
      { len--; goto tryagain; }
    else return FALSE;		/* no possible match */

  *matched = len;
  if (b == NULL)	/* only one instance of at least part of word */
  {
    strcpy(commonchars,a);
    return (0 == strcmp(word,commonchars));	/* maybe a commplete match */
  }

	/* Have a range of words in list that match the first len chars of
	 *   word.
	 * All words in range have their first len chars in common.
	 * Now find the most characters that the words in range have in
	 *   common.  This can be lots more than len.
	 */
  for (len--; c = *(a + len); len++)
  {
    mover(REWIND, (char **)NULL);
    while (TRUE)	/* move to the start of the range */
    {
      mover(NEXT, &ptr);
      if (ptr == a) break;
    }
    for (; ; mover(NEXT, &ptr))		/* move though the range */
    {
      if (*ptr != '\0' && *(ptr + len) != c) goto done;	/* mismatch */
      if (ptr == b) break;
    }
  }
done:
  strcpy(commonchars,a); commonchars[len] = '\0';

  return FALSE;
}
