/* os.h : machine and OS specific stuff
 * Craig Durland	Public Domain
 * Notes:
 *   This file is self configuring on HP-UX, Apollo Domain OS, IBM AIX, IBM
 *     PCs (at least for Borland C++, hopefully others).
 *   This file does need configuring for Suns, OS/2, Atari.
 */

#ifndef __OS_H_INCLUDED
#define __OS_H_INCLUDED

/* ******************************************************************** */
/* ***************************** OS Types ***************************** */
/* ******************************************************************** */

/* Notes:
 *   Set ONE of the OS types to 1 (unless the instructions indicate
 *   otherwise).
 */

#ifdef __MSDOS__
#define MSDOZ		1	/* MS-DOS */
#endif

#define ATARI		0	/* AtariST/TT TOS or MiNT */


#define OS2             0	/* OS/2 */
#if OS2
#undef  MSDOZ
#define MSDOZ 1
#endif

#define AMIGA		0	/* AmigaDOS !NOT SUPPORTED! */

	/* ******************** Unix ************************ */

	/* ******************** HP-UX ************************ */
#ifdef __hpux			/* HP-UX */
#define SYSV_OS		1
#endif	/* __hpux */


	/* ************** Apollo Domain OS (BSD) ************** */
#ifdef __apollo
#define DOMAIN_OS	1
#define BSD_OS		1
#else
#define DOMAIN_OS	0
#endif	/* __apollo */


	/* ******************** IBM AIX ************************ */
#ifdef _AIX			/* IBM AIX */
#define AIX_OS		1
#define SYSV_OS		1
#else
#define AIX_OS		0
#endif	/* _AIX */


	/* ************** Unknown (to me) Unix **************** */
   /* If your Unix is not one of the above, you'll need to set one of these
    *   constants manually.
    * Notes:
    *   Some systems are mixes.  HP-UX is a mix of BSD and SysV.  Newer DEC
    *     systems have Posix stuff in them.  This can make writing portable
    *     code a real pain in the butt.  Pick the best match(es) and hope.
    *   Sun:  Older Suns are BSD, the newer ones (with the SysV file system)
    *     are SysV or Posix (you can set either).
    */
#if 0	/* set to 1 if you need to set one of these */
#define V7_OS		0 /* V7 UN*X or Coherent */
#define BSD_OS		0 /* Sun, DEC, Apollo bsd4.3, ... */
#define SYSV_OS		0 /* Newer Suns, HP-UX, IBM, Apollo SysV, ... */
#define POSIX_OS	0 /* Posix compliant: osf */	
#endif


	/* ********** Some Universal Unix Macros ************** */

#define UX_OS	(V7_OS || BSD_OS || SYSV_OS || POSIX_OS)

	/* ************** End Unix **************** */

/* ******************************************************************** */
/* ************************** Machine & CPU *************************** */
/* ******************************************************************** */

typedef unsigned char      uint8;	/* byte */
typedef unsigned short int uint16;	/* 2 bytes */
typedef short int	    int16;	/* 16 bit int */
typedef long  int	    int32;	/* 32 bit int */

/* ******************************************************************** */
/* ********************** Directry Related Stuff ********************** */
/* ******************************************************************** */

#define M_SLASH '\\'	/* file seperator for MS-DOS */
#define U_SLASH '/'	/* file seperator for UN*X */

#if MSDOZ || ATARI
#define ISSLASH(c) ((c) == U_SLASH || (c) == M_SLASH)
#else
#define ISSLASH(c) ((c) == U_SLASH)
#endif /* MSDOZ || ATARI */

#if MSDOZ
	/* File attributes */
	/* Note: attribute == 0 => normal file */
#define FA_RD_ONLY   0x01	/* read only */
#define FA_HIDDEN    0x02	/* hidden */
#define FA_SYSTEM    0x04	/* system */
#define FA_VOLUME    0x08	/* volume */
#define FA_DIRECTORY 0x10	/* directory */
#define FA_ARCHIVE   0x20	/* archive */
#define FA_Z	     0x80	/* my fake bit to match attr == 0 */
#endif /* MSDOZ */

#endif /* __OS_H_INCLUDED */
