/*
 * Some support routines for MS-DOS.  These are directory/disk search
 *   routines in Lattice C but not in other Cs.
 * J Burnell  3/92	Public Domain
 */

#include <string.h>
#define INCL_BASE
#include <os2.h>

#include <dir.h>

#include "ibmdir.h"

int dfind (struct FILEINFO *buffer, const char *path, int attrib)
{
  FILEFINDBUF FindBuffer;
  USHORT FindHandle, FindCount;

  FindHandle = 1;
  FindCount = 1;

  if (DosFindFirst(path, &FindHandle, attrib, &FindBuffer,
    sizeof (FindBuffer), &FindCount, 0L))
    return 1;
  else {
    buffer->attr = FindBuffer.attrFile;
    strncpy (buffer->name, FindBuffer.achName, FindBuffer.cchName);
    buffer->name [FindBuffer.cchName] = 0;
    return 0;
  }
}

int dnext (struct FILEINFO *buffer)
{
  FILEFINDBUF FindBuffer;
  USHORT FileCount;

  FileCount = 1;

  if (DosFindNext(1, &FindBuffer, sizeof (FindBuffer), &FileCount))
    return 1;
  else {
    buffer->attr = FindBuffer.attrFile;
    strncpy (buffer->name, FindBuffer.achName, FindBuffer.cchName);
    buffer->name [FindBuffer.cchName] = 0;
    return 0;
  }
}

int getdsk (void) {
    USHORT tmp;
    ULONG drive;

    DosQCurDisk(&tmp, &drive);

    return (tmp) - 1;
}

int getcd (int drive, char *dir) {
  return getcurdir (drive, dir);
}
