/*
 * Some support routines for MS-DOS.  These are directory/disk search
 *   routines in Lattice C but not in other Cs.
 * In Lattice C, these routines are minimal front ends to int 21 dos calls.
 * J Burnell  3/92	Public Domain
 */

#include <string.h>
#include <dos.h>
#include <dir.h>
#include "ibmdir.h"

static struct ffblk find_buf;

int dfind (struct FILEINFO *buffer, const char *path, int attrib)
{
/* returns TRUE if no match found, FALSE otherwise */

  if (!findfirst (path, &find_buf, attrib)) {
    buffer->attr = find_buf.ff_attrib;
    strcpy (buffer->name, find_buf.ff_name);
    return 0;
  } else
    return 1;
}

int dnext (struct FILEINFO *buffer)
{
/* returns TRUE if no match found, FALSE otherwise   */

  if (!findnext (&find_buf)) {
    buffer->attr = find_buf.ff_attrib;
    strcpy (buffer->name, find_buf.ff_name);
    return 0;
  } else
    return 1;
}

int getdsk (void) {

  return getdisk ();
}

int getcd (int drive, char *dir) {
  return getcurdir (drive, dir);
}
