/* l_to_a.c:  Convert an long integer to a string.
 * The string is stored in this routine so it will be overwritten every time
 *   the routine is called.
 * C Durland	Public Domain
 */

#include "const.h"

char *l_to_a(n) long int n;   /* only difference from i_to_a() */
{
  static char str[DIGITS_PER_INT(sizeof(long int)) + 1];

  register char *ptr = &str[DIGITS_PER_INT(sizeof(long int))];
  int minus = FALSE;
  register unsigned long int x = n;

  if (n < 0) { minus = TRUE; x = -n; }
  *ptr = '\0';
  do { *--ptr = (x % 10) +'0'; x /= 10; } while (x>0);
  if (minus) *--ptr = '-';
  return ptr;
}
