/* i_to_a.c:  Convert an integer to a string.
 * The string is stored in this routine so it will be overwritten every time
 *   the routine is called.
 * C Durland	Public Domain
 */

#include "const.h"

char *i_to_a(n) int n;
{
  static char str[DIGITS_PER_INT(sizeof(int)) + 1];

  register char *ptr = &str[DIGITS_PER_INT(sizeof(int))];
  int minus = FALSE;
  register unsigned int x = n;

  if (n < 0) { minus = TRUE; x = -n; }
  *ptr = '\0';
  do { *(--ptr) = (x % 10) +'0'; x /= 10; } while (x>0);
  if (minus) *(--ptr) = '-';
  return ptr;
}
