/*
 *  fname.c:  Mess with file names, paths.
 *  C Durland	Public Domain
 *  See also:  fpath.c
 */

#include <stdio.h>
#include "os.h"

#define DOT   '.'
#define DRIVE ':'		/* for MS-DOS anyway */

char *strcpy();

	/* Point to the end of the path.
	 * The resulting path is such that you can cd to it.
	 * Use nanex() if you want to append a new name.
	 * To leave just the path:  *pathend(fname) = '\0';
	 * Examples: (^ shows what pathend() points to)
	 *   "foo/bar", "/foo", "/", "/foo/"
	 *       ^        ^       ^       ^
	 *   "..", ".", "/..", "foo."
	 *      ^    ^      ^   ^
	 *   ".foo", "foo", ""
	 *    ^       ^      ^
	 * MS-DOS:
	 *   "A:", "A:foo", "A:/", "A:/foo"
	 *      ^     ^         ^      ^
	 */
char *pathend(fname) register char *fname;
{
  register char *ptr = fname + strlen(fname);

  while (ptr != fname)
  {
    ptr--;
    if (ISSLASH(*ptr))
    {
      if (ptr == fname) ptr++;			/* /, /foo */
#if MSDOZ || ATARI
      else if (ptr[-1] == DRIVE) ptr++;		/* A:/, A:/foo */
#endif
      break;
    }
#if MSDOZ || ATARI
    if (*ptr == DRIVE) { ptr++; break; }	/* A:, A:foo */
#endif
  }
  if (*ptr == DOT)			/* might have . or .. */
  {
    if (ptr[1] == '\0') ptr++;				/* "." */
    else
      if (ptr[1] == DOT && ptr[2] == '\0') ptr += 2;	/* ".." */
  }	
  return ptr;
}

	/* Point to the filename & extension.
	 * Assumes a real filename & no trailing junk.
	 */
char *nanex(fname) register char *fname;
{
  fname = pathend(fname);
  if (ISSLASH(*fname)) fname++;
  return fname;
}

	/* Point to start of extension (ie the '.')
	 *   The first "." after the last "/".
	 * Assumes a real filename.
	 * Notes:
	 *   foo.c => ".c"
	 *   foo => ""
	 *   .foo.bar => ".bar" (UNIX hidden files).
	 *   .foo => ".foo"  (csh does this).
	 *   y.tab.c => ".c".
	 *   "" => ""
	 *   foo. => "."
	 */
char *ext(fname) register char *fname;
{
  char *ptr, *end;

  fname = nanex(fname);				/* start of the file name */
  end = ptr = fname + strlen(fname);		/* end of file name ('\0') */

  for ( ; (ptr != fname) && (*ptr != DOT); ptr--) ;

  if (*ptr != DOT) return end;			/* no extension */
  return ptr;
}

	/* for UNIX: .foo => .foo.ext?  (not yet)
	 * ..\fred.foo
	 *  ext MUST start with a '.'
	 */
char *new_ext(newname,nameext,newext) char *newname, *nameext, *newext;
{
  strcpy(ext(strcpy(newname,nameext)),newext);
  return newname;
}

