#include "stdio.h"
#include "const.h"

#ifdef __STDC__
#include <stdarg.h>

void dump_doc(char *ptr, ...)
{
  va_list varptr;

  va_start(varptr, ptr);
  while (ptr != NULL)
  {
    puts(ptr);
    ptr = va_arg(varptr,char *);
  }
  va_end(varptr);
}

void fdump_doc(FILE *stream, char *ptr, ...)
{
  va_list varptr;

  va_start(varptr, ptr);
  while (ptr != NULL)
  {
    fputs(ptr,stream); fputs("\n",stream);
    ptr = va_arg(varptr,char *);
  }
  va_end(varptr);
}

#else	/*  __STDC__ */

#include <varargs.h>

void dump_doc(va_alist) va_dcl
{
  char *ptr;
  va_list varptr;

  va_start(varptr);
  while (NULL != (ptr = va_arg(varptr,char *))) puts(ptr);
  va_end(varptr);
}

void fdump_doc(stream, va_alist) FILE *stream; va_dcl
{
  char *ptr;
  va_list varptr;

  va_start(varptr);
  while (NULL != (ptr = va_arg(varptr,char *)))
  	{ fputs(ptr,stream); fputs("\n",stream); }
  va_end(varptr);
}

#endif	/*  __STDC__ */





/* ****************  TEST ********************* */
#ifdef TEST

main()
{
  dump_doc("--------",(char *)NULL);
  dump_doc((char *)NULL);
  dump_doc("this is a test","*****", (char *)NULL);
  
}

#endif
