/* dtable.h : dynamic tables header file.
 * See dtable.c for more info.
 * All routines, macros, etc use pointers to dTables.
 *
 * C Durland	Public Domain
 */

#ifndef __DTABLE_H_INCLUDED
#define __DTABLE_H_INCLUDED

#define declare_dTable_of(blob) struct { DTABLE(blob); }
#define declare_and_init_dTable(name,blob)	\
	struct { DTABLE(blob); } name = initial_dTable_data(name)

#define sizeof_dTable(dtable)	(dtable)->num_items
#define reset_dTable(dtable)	sizeof_dTable(dtable) = 0


#define INIT_dTable(dtable)			\
	initialize_dTable(dtable,dTable_BLOBSIZE(dtable))



#define initial_dTable_data(name) { 0,0, dTable_BLOBSIZE(&name) }

#define dTable_BLOBSIZE(dtable) sizeof((dtable)->table[0])

#define DTABLE(blob)	\
	unsigned int num_items, max_items; int blob_size; blob *table
typedef struct { DTABLE(char); } dTable;

#endif /* __DTABLE_H_INCLUDED */
