/* dstring.c: dynamic strings.
 * C Durland	Public Domain
 */

#include "const.h"
#include "dstring.h"

extern char *malloc(), *realloc(), *strcpy();

static char empty_string[1] = { '\0' };

	/* Note:  You must initialize a dString.  If it is declared as a
	 *   global var, it is initialized enough if you set it before you
	 *   get it.
	 */
void init_dString(ds) register dString *ds;
{
  ds->size = 0; ds->string = empty_string;
}

	/* Returns: TRUE is ok, FALSE if could not malloc (string set to
	 *   empty_string).
	 */
set_dString(ds,text) register dString *ds; char *text;
{
  if (!pad_dString(ds,strlen(text))) return FALSE;

  strcpy(ds->string,text);

  return TRUE;
}

void free_dString(ds) register dString *ds;
{
  if (ds->size) free(ds->string);
  init_dString(ds);
}

    /* Make sure dString has enough space in it to hold a string of length
     *   len.  Also leave room for the \0.
     * Notes:
     *   dString contents are sometimes trashed by this routine.
     *   The location of the text might be moved so don't say 
     *     ptr = ds->string, pad_dString(ds) and expect ptr to be valid!
     *   Some routines will want the orginal contents to be intact after the
     *     pad so that can do things like strcat().
     *   !!!Under Ansi C, I'll need to free the dstring if the realloc()
     *     fails.  Of course this doesn't work everywhere so I'll blow it
     *     off.
     * Input:
     *   ds  : Pointer to dString that needs some room
     *   len : Strlen of string that ds needs to be able to hold.
     * Output:
     *   ds : Expanded dString.  Freed and initialized if no memory (ie old
     *     contents are gone).
     * Returns:
     *   TRUE:   Everything went as expected.
     *   FALSE:  Out of memory.
     */
pad_dString(ds,len) register dString *ds; int len;
{
  char *ptr;
  int size = ds->size;

  len++;
  if (len <= size) return TRUE;

  if (size)		/* dString has already been malloc()ed */
	ptr = realloc(ds->string, len);
  else  ptr = malloc(len);

  if (!ptr) { init_dString(ds); return FALSE; }

  ds->size = len;
  ds->string = ptr;

  return TRUE;
}

#if 0
char *malloc(), *realloc(), *strcat();
cat_dString(ds,string) register dString *ds; char *string;
{
  register char *ptr = ds->string;
  register int n = strlen(string) +1, size = ds->size;

  if (size<n)	/* expand string */
  {
    ptr = size ? realloc(ptr,n) : malloc(n);
    if (ptr == NULL) { init_dString(ds); return 0; }
    if (!size) *ptr = '\0';
    ds->size = n;
  }
  ds->string = strcat(ptr,string);
  return 1;
}
#endif


#ifdef TEST
/* ******************************************************************** */
/* ***********  TESTING *********************************************** */
/* ******************************************************************** */

#include <stdio.h>

main()
{
  char buf[200];
  dString ds;

  init_dString(&ds);
  while (1)
  {
    printf(">>>>s(set string), p(print string), q(quit): ");
    gets(buf); puts("");
    switch (*buf)
    {
      case 's':	/* set string */
	printf("string: "); gets(buf); puts("");
	set_dString(&ds,buf);
	break;
      case 'p':	/* print string */
	printf(">%s<\n",ds.string);
	break;
      case 'q': goto done;
    }
  }
  done: ;
}
#endif
