/* const.h : constants, typedefs and macros that I use
 * C Durland	Public Domain
 */

#ifndef __CONST_H_INCLUDED
#define __CONST_H_INCLUDED

/* ******************************************************************** */
/* **************************** Constants ***************************** */
/* ******************************************************************** */

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

/* ******************************************************************** */
/* ***************************** Typedefs ***************************** */
/* ******************************************************************** */

typedef int  (*pfi)();		/* pointer to function returning int */
typedef void (*pfv)();		/* pointer to function returning void */

/* ******************************************************************** */
/* ****************************** Macros ****************************** */
/* ******************************************************************** */

	/* size of static array */
#define NITEMS(array) (sizeof(array)/sizeof(array[0]))

	/* increment a type (usually pointer) by n bytes */
#define INC_TYPE(type,ptr,n) (type)((char *)ptr +n)

    /* Calculate the number of decimal digits per integer type (including
     *   the sign).  Type size is sizeof(type) - bytes.
     * Formula:  round_up(Log10(bytes)) + 1 (for sign)
     * Approximation: 2*bytes + (bytes + 1)/2 + 1
     *   This is good for (at least) 32 bytes - it may add a digit or two
     *     above 6 bytes.
     */
#define DIGITS_PER_INT(bytes) ((bytes)*2 + ((bytes) + 1)/2 + 1)


#endif	/* __CONST_H_INCLUDED */
