/*
 * char.h:  a replacement ctype.h
 * C Durland	Public Domain
 */

/*
 * isalnum(c)	non-zero if c is alpha or digit
 * isalpha(c)	non-zero if c is alpha
 * isascii(c)	non-zero if c is ASCII
 * iscntrl(c)	non-zero if c is control character
 * isdigit(c)	non-zero if c is a digit (0 to 9)
 * islower(c)	non-zero if c is lower case
 * ispunct(c)	non-zero if c is punctuation
 * isspace(c)	non-zero if c is white space
 * isupper(c)	non-zero if c is upper case

 * isprint(c)	non-zero if c is printable (including blank)
 * isgraph(c)	non-zero if c is graphic (excluding blank)
  
 * _toupper(c)	jam c to uppercase no matter what
 * TOUPPER(c)	convert c to uppercase if it is lowercase
 * _tolower(c)	jam c to lowercase no matter what
 * TOLOWER(c)	convert c to lowercase if it is uppercase
 */

#ifndef __CHAR_H_INCLUDED
#define __CHAR_H_INCLUDED

#define	_W	0x01	/* Word */
#define	_U	0x02	/* Upper case letter */
#define	_L	0x04	/* Lower case letter */
#define	_C	0x08	/* Control */
#define _N	0x10	/* number */
#define _S	0x20	/* space */
#define _P	0x40	/* punctuation */

extern unsigned char _cinfo[];	/* in char.c */

#define isalnum(c)	(_cinfo[(unsigned char)(c)] & (_U|_L|_N))
#define isalpha(c)	(_cinfo[(unsigned char)(c)] & (_U|_L))
#define	iscntrl(c)	(_cinfo[(unsigned char)(c)] & _C)
#define isdigit(c)	(_cinfo[(unsigned char)(c)] & _N)
#define	islower(c)	(_cinfo[(unsigned char)(c)] & _L)
#define ispunct(c)	(_cinfo[(unsigned char)(c)] & _P)
#define isspace(c)	(_cinfo[(unsigned char)(c)] & _S)
#define	isupper(c)	(_cinfo[(unsigned char)(c)] & _U)
#define	isword(c)	(_cinfo[(unsigned char)(c)] & _W)

#define isgraph(c)	(_cinfo[(unsigned char)(c)] & (_U|_L|_N|_P))
#define isprint(c)	(_cinfo[(unsigned char)(c)] & (_U|_L|_N|_P|_S))

#define toascii(c)	((unsigned char)(c) & 0x7F)

#define add_cinfo(c,x)    _cinfo[(unsigned char)(c)] |= x
#define remove_cinfo(c,x) _cinfo[(unsigned char)(c)] &= ~(x)

#ifndef CHAR_MAPS

	/* Note:  these only really work with ASCII ie < 0x7F */
#define	_toupper(c)	((unsigned char)(c) & 0xDF)
#define	TOUPPER(c)	(islower(c) ? _toupper(c) : (c))
#define	_tolower(c)	((unsigned char)(c) | ' ')
#define	TOLOWER(c)	(isupper(c) ? _tolower(c) : (c))

#else

extern unsigned char _lcmap[], _ucmap[];

#define	_toupper(c)	_ucmap[(unsigned char)(c)]
#define	TOUPPER(c)	_ucmap[(unsigned char)(c)]
#define	_tolower(c)	_lcmap[(unsigned char)(c)]
#define	TOLOWER(c)	_lcmap[(unsigned char)(c)]

#define set_toupper(a,A) _ucmap[(unsigned char)(a)] = (A)
#define set_tolower(A,a) _lcmap[(unsigned char)(A)] = (a)

#endif

	/* Case insensitive table stuff.
	 * Define _cmap[256] in your code and munge it.
	 */
extern unsigned char _cmap[];

		/* character compare */
#define ceq(c1,c2) (_cmap[(unsigned char)(c1)] == _cmap[(unsigned char)(c2)])

#endif	/* __CHAR_H_INCLUDED */
