/*
 * Array used by char.h plus some character routines
 * C Durland	Public Domain
 */

#include "char.h"

toupper(c) register unsigned char c; { return (int)TOUPPER(c); }
tolower(c) register unsigned char c; { return (int)TOLOWER(c); }

unsigned char _cinfo[256] =	/* info about a character */
{
/* 0        1        2        3        4        5        6        7 */
/* 8        9        A        B        C        D        E        F */
  _C,      _C,      _C,      _C,      _C,      _C,      _C,      _C,	/* 0*/
  _C,      _C|_S,   _C|_S,   _C|_S,   _C|_S,   _C|_S,   _C,      _C,	/* 8*/
  _C,      _C,      _C,      _C,      _C,      _C,      _C,      _C,    /*10*/
  _C,      _C,      _C,      _C,      _C,      _C,      _C,      _C,    /*18*/
  _S,      _P,      _P,      _P,      _P|_W,   _P,      _P,      _P|_W, /*20*/
  _P,      _P,      _P,      _P,      _P,      _P,      _P,      _P,    /*28*/
  _N|_W,   _N|_W,   _N|_W,   _N|_W,   _N|_W,   _N|_W,   _N|_W,   _N|_W, /*30*/
  _N|_W,   _N|_W,   _P,      _P,      _P,      _P,      _P,      _P,	/*38*/
  _P,      _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W, /*40*/
  _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W, /*48*/
  _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W,   _U|_W, /*50*/
  _U|_W,   _U|_W,   _U|_W,   _P,      _P,      _P,      _P,      _P|_W,	/*58*/
  _P,      _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W, /*60*/
  _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W, /*68*/
  _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W,   _L|_W, /*70*/
  _L|_W,   _L|_W,   _L|_W,   _P,      _P,      _P,      _P,      _C,    /*78*/

	/* 80 and above is user responsiblity */
};

#ifdef CHAR_MAPS

unsigned char _cmap[256];	/* character map */

void fix_cmap(case_fold)
{
  register int c;

  for (c = 255; c--; ) _cmap[c] = case_fold ? toupper(c) : c;
}

unsigned char _lcmap[256] =	/* convert character to lower case map */
{
/* 0        1        2        3        4        5        6        7 */
/* 8        9        A        B        C        D        E        F */
  0x00,    0x01,    0x02,    0x03,   0x04,    0x05,    0x06,     0x07,	/* 0*/
  0x08,    0x09,    0x0A,    0x0B,   0x0C,    0x0D,    0x0E,     0x0F,	/* 8*/
  0x10,    0x11,    0x12,    0x13,   0x14,    0x15,    0x16,     0x17,  /*10*/
  0x18,    0x19,    0x1A,    0x1B,   0x1C,    0x1D,    0x1E,     0x1F,  /*18*/
  ' ',     0x21,    0x22,    0x23,   0x24,    0x25,    0x26,     0x27,  /*20*/
  0x28,    0x29,    0x2A,    0x2B,   0x2C,    0x2D,    0x2E,     0x2F,  /*28*/
  '0',     '1',     '2',     '3',    '4',     '5',     '6',      '7',	/*30*/
  '8',     '9',     0x3A,    0x3B,   0x3C,    0x3D,    0x3E,     0x3F,	/*38*/
  0x40,    'a',     'b',     'c',    'd',     'e',     'f',      'g',   /*40*/
  'h',     'i',     'j',     'k',    'l',     'm',     'n',      'o',   /*48*/
  'p',     'q',     'r',     's',    't',     'u',     'v',      'w',   /*50*/
  'x',     'y',     'z',     0x5B,   0x5C,    0x5D,    0x5E,     0x5F,	/*58*/
  0x60,    'a',     'b',     'c',    'd',     'e',     'f',      'g',   /*60*/
  'h',     'i',     'j',     'k',    'l',     'm',     'n',      'o',   /*68*/
  'p',     'q',     'r',     's',    't',     'u',     'v',      'w',   /*70*/
  'x',     'y',     'z',     0x7B,   0x7C,    0x7D,    0x7E,     0x7F,  /*78*/
  0x80,    0x81,    0x82,    0x83,   0x84,    0x85,    0x86,     0x87,  /*80*/
  0x88,    0x89,    0x8A,    0x8B,   0x8C,    0x8D,    0x8E,     0x8F,  /*88*/
  0x90,    0x91,    0x92,    0x93,   0x94,    0x95,    0x96,     0x97,  /*90*/
  0x98,    0x99,    0x9A,    0x9B,   0x9C,    0x9D,    0x9E,     0x9F,  /*98*/
  0xA0,    0xA1,    0xA2,    0xA3,   0xA4,    0xA5,    0xA6,     0xA7,  /*A0*/
  0xA8,    0xA9,    0xAA,    0xAB,   0xAC,    0xAD,    0xAE,     0xAF,  /*A8*/
  0xB0,    0xB1,    0xB2,    0xB3,   0xB4,    0xB5,    0xB6,     0xB7,  /*B0*/
  0xB8,    0xB9,    0xBA,    0xBB,   0xBC,    0xBD,    0xBE,     0xBF,  /*B8*/
  0xC0,    0xC1,    0xC2,    0xC3,   0xC4,    0xC5,    0xC6,     0xC7,  /*C0*/
  0xC8,    0xC9,    0xCA,    0xCB,   0xCC,    0xCD,    0xCE,     0xCF,  /*C8*/
  0xD0,    0xD1,    0xD2,    0xD3,   0xD4,    0xD5,    0xD6,     0xD7,  /*D0*/
  0xD8,    0xD9,    0xDA,    0xDB,   0xDC,    0xDD,    0xDE,     0xDF,  /*D8*/
  0xE0,    0xE1,    0xE2,    0xE3,   0xE4,    0xE5,    0xE6,     0xE7,  /*E0*/
  0xE8,    0xE9,    0xEA,    0xEB,   0xEC,    0xED,    0xEE,     0xEF,  /*E8*/
  0xF0,    0xF1,    0xF2,    0xF3,   0xF4,    0xF5,    0xF6,     0xF7,  /*F0*/
  0xF8,    0xF9,    0xFA,    0xFB,   0xFC,    0xFD,    0xFE,     0xFF,  /*F8*/
};

unsigned char _ucmap[256] =	/* convert character to upper case map */
{
/* 0        1        2        3        4        5        6        7 */
/* 8        9        A        B        C        D        E        F */
  0x00,    0x01,    0x02,    0x03,   0x04,    0x05,    0x06,     0x07,	/* 0*/
  0x08,    0x09,    0x0A,    0x0B,   0x0C,    0x0D,    0x0E,     0x0F,	/* 8*/
  0x10,    0x11,    0x12,    0x13,   0x14,    0x15,    0x16,     0x17,  /*10*/
  0x18,    0x19,    0x1A,    0x1B,   0x1C,    0x1D,    0x1E,     0x1F,  /*18*/
  ' ',     0x21,    0x22,    0x23,   0x24,    0x25,    0x26,     0x27,  /*20*/
  0x28,    0x29,    0x2A,    0x2B,   0x2C,    0x2D,    0x2E,     0x2F,  /*28*/
  '0',     '1',     '2',     '3',    '4',     '5',     '6',      '7',	/*30*/
  '8',     '9',     0x3A,    0x3B,   0x3C,    0x3D,    0x3E,     0x3F,	/*38*/
  0x40,    'A',     'B',     'C',    'D',     'E',     'F',      'G',   /*40*/
  'H',     'I',     'J',     'K',    'L',     'M',     'N',      'O',   /*48*/
  'P',     'Q',     'R',     'S',    'T',     'U',     'V',      'W',   /*50*/
  'X',     'Y',     'Z',     0x5B,   0x5C,    0x5D,    0x5E,     0x5F,	/*58*/
  0x60,    'A',     'B',     'C',    'D',     'E',     'F',      'G',   /*60*/
  'H',     'I',     'J',     'K',    'L',     'M',     'N',      'O',   /*68*/
  'P',     'Q',     'R',     'S',    'T',     'U',     'V',      'W',   /*70*/
  'X',     'Y',     'Z',     0x7B,   0x7C,    0x7D,    0x7E,     0x7F,  /*78*/
  0x80,    0x81,    0x82,    0x83,   0x84,    0x85,    0x86,     0x87,  /*80*/
  0x88,    0x89,    0x8A,    0x8B,   0x8C,    0x8D,    0x8E,     0x8F,  /*88*/
  0x90,    0x91,    0x92,    0x93,   0x94,    0x95,    0x96,     0x97,  /*90*/
  0x98,    0x99,    0x9A,    0x9B,   0x9C,    0x9D,    0x9E,     0x9F,  /*98*/
  0xA0,    0xA1,    0xA2,    0xA3,   0xA4,    0xA5,    0xA6,     0xA7,  /*A0*/
  0xA8,    0xA9,    0xAA,    0xAB,   0xAC,    0xAD,    0xAE,     0xAF,  /*A8*/
  0xB0,    0xB1,    0xB2,    0xB3,   0xB4,    0xB5,    0xB6,     0xB7,  /*B0*/
  0xB8,    0xB9,    0xBA,    0xBB,   0xBC,    0xBD,    0xBE,     0xBF,  /*B8*/
  0xC0,    0xC1,    0xC2,    0xC3,   0xC4,    0xC5,    0xC6,     0xC7,  /*C0*/
  0xC8,    0xC9,    0xCA,    0xCB,   0xCC,    0xCD,    0xCE,     0xCF,  /*C8*/
  0xD0,    0xD1,    0xD2,    0xD3,   0xD4,    0xD5,    0xD6,     0xD7,  /*D0*/
  0xD8,    0xD9,    0xDA,    0xDB,   0xDC,    0xDD,    0xDE,     0xDF,  /*D8*/
  0xE0,    0xE1,    0xE2,    0xE3,   0xE4,    0xE5,    0xE6,     0xE7,  /*E0*/
  0xE8,    0xE9,    0xEA,    0xEB,   0xEC,    0xED,    0xEE,     0xEF,  /*E8*/
  0xF0,    0xF1,    0xF2,    0xF3,   0xF4,    0xF5,    0xF6,     0xF7,  /*F0*/
  0xF8,    0xF9,    0xFA,    0xFB,   0xFC,    0xFD,    0xFE,     0xFF,  /*F8*/
};

unsigned char _lcmap[256], _lcmap[256];		/* case folding maps */

void init_cmaps(case_fold)
{
  register int c, C;

  for (c = 255; c--; ) _lcmap[c] = _ucmap[c] = c;
mod_cmaps("FaAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ");
for (C = 'A'; C<='Z'; C++)
{ c = C | ' '; set_toupper(c,C); set_tolower(C,c); }
  fix_cmap(case_fold);
}

	/* modify the info and case folding maps
	 * format:
	 *   W<letters> : letters are NOT part of words.
	 *   w<letters> : letters are part of words.
	 *   l<aAbB...> : lowercasing A returns a.
	 *   u<aAbB...> : uppercasing a returns A.
	 *   f<aAbB...> : same as u<aAbB...> l<aAbB...>.
	 */
mod_cmaps(ptr) register unsigned char *ptr;
{
  register int n = strlen(ptr) -1, x, c, C, z;

  switch(*ptr++)
  {
    case 'W': x = _W; z = 0; break;
    case 'w': x = _W; z = 1; break;
    case 'u': x = _U; z = 2; break;
    case 'l': x = _L; z = 2; break;
    case 'f': x = _U | _L; z = 2; break;
    default: return FALSE;
  }
  switch (z)
  {
    case 0: while (n--) remove_cinfo(*ptr++,x); break;
    case 1: while (n--)    add_cinfo(*ptr++,x); break;
    case 2:
      n /= 2;
      while (n--)
      {
	c = *ptr++; C = *ptr++;
	if (x&_U) { set_toupper(c,C); add_cinfo(c,_L); }
	if (x&_L) { set_tolower(c,C); add_cinfo(C,_U); }
      }
      break;
  }
  return TRUE;
}

#endif
